AJS.test.require(['com.pyxis.greenhopper.jira:gh-test-common', 'com.pyxis.greenhopper.jira:gh-rapid', 'com.pyxis.greenhopper.jira:gh-onboarding'], function () {
    var BacklogModel = require('jira-agile/rapid/ui/plan/backlog-model');
    var IssueListModel = require('jira-agile/rapid/ui/plan/issue-list-model');
    var SprintBacklogView = require('jira-agile/rapid/ui/plan/sprint-backlog-view');
    var globalEvents = require('jira-agile/rapid/global-events');

    var planOnboarding = require('jira-agile/rapid/ui/plan/plan-onboarding');
    var common = {
        setup: function setup() {

            AJS.$('#qunit-fixture').append('<div class="js-add-sprint"></div>');
            AJS.$('#qunit-fixture').append('<div class="js-sprint-container" data-sprint-id=1><div class="js-sprint-start"></div><div class="ghx-helper"></div></div>');

            this.sandbox = sinon.sandbox.create();

            var mockEpicModel = new GH.EpicModel();
            mockEpicModel.epicsList = new IssueListModel('test', [], null);
            this.sandbox.stub(GH.EpicController, 'getEpicModel').returns(mockEpicModel);

            // data for ScrumBase and KanPlanBase decide if it can handle the data or not
            GH.RapidViewConfig.currentData.data = {
                sprintSupportEnabled: true
            };

            BacklogModel.setData({ issues: [], sprints: [] });
            this.sandbox.stub(BacklogModel, 'canManageSprints').returns(true);

            this.sandbox.stub(GH.SprintView, 'calculateSprintIssueListStats').returns({ totalCount: 1 });

            this.events = {
                onButtonState: this.sandbox.spy(),
                onRefresh: this.sandbox.spy(),
                onHide: this.sandbox.spy()
            };
            planOnboarding.on('button-state', this.events.onButtonState, this);
            planOnboarding.on('refresh', this.events.onRefresh, this);
            planOnboarding.on('hide', this.events.onHide, this);

            globalEvents.trigger('pre-initialization');
        },
        teardown: function teardown() {
            planOnboarding.off(this);
            this.sandbox.restore();
        }
    };

    function appendBacklogMessageContainers(element) {
        var backlog = AJS.$('<div class="ghx-backlog-group"/>');
        backlog.append('<div class="ghx-onboarding-fillyourbacklog-group"/>');
        backlog.append('<div class="ghx-helper">empty</div>');
        element.append(backlog);
    }

    module('Plan Onboarding - condition for CREATE sprint button onboarding', {
        setup: function setup() {
            common.setup();
        },
        teardown: function teardown() {
            common.teardown();
        }
    });

    test('happy path', function () {
        BacklogModel.setData({ issues: [{ key: 'GD-1' }, { key: 'GD-2' }, { key: 'GD-3' }], sprints: [] });
        planOnboarding.renderOnboarding();
        var buttonElement = AJS.$('.js-add-sprint');
        ok(buttonElement.hasClass('aui-button-primary'));
    });

    test('no permission', function () {
        AJS.$('.js-add-sprint').addClass('aui-button-primary');
        BacklogModel.canManageSprints.returns(false);
        BacklogModel.setData({ issues: [{ key: 'GD-1' }, { key: 'GD-2' }, { key: 'GD-3' }], sprints: [] });
        planOnboarding.renderOnboarding();
        var buttonElement = AJS.$('.js-add-sprint');
        ok(!buttonElement.hasClass('aui-button-primary'));
    });

    test('future sprint present', function () {
        AJS.$('.js-add-sprint').addClass('aui-button-primary');
        BacklogModel.setData({ issues: [{ key: 'GD-1' }, { key: 'GD-2' }, { key: 'GD-3' }], sprints: [{ id: 1, name: 'Sprint 2', state: 'FUTURE' }] });
        planOnboarding.renderOnboarding();
        var buttonElement = AJS.$('.js-add-sprint');
        ok(!buttonElement.hasClass('aui-button-primary'), 'create sprint button should not be primary');
    });

    test('active sprint present', function () {
        AJS.$('.js-add-sprint').addClass('aui-button-primary');
        BacklogModel.setData({ issues: [{ key: 'GD-1' }, { key: 'GD-2' }, { key: 'GD-3' }], sprints: [{ id: 1, name: 'Sprint 2', state: 'ACTIVE' }] });
        planOnboarding.renderOnboarding();
        var buttonElement = AJS.$('.js-add-sprint');
        ok(!buttonElement.hasClass('aui-button-primary'), 'create sprint button should not be primary');
    });

    test('less than 3 issues in backlog', function () {
        BacklogModel.setData({ issues: [{ key: 'GD-1' }, { key: 'GD-2' }], sprints: [] });
        planOnboarding.renderOnboarding();
        var buttonElement = AJS.$('.js-add-sprint');
        ok(!buttonElement.hasClass('aui-button-primary'));
    });

    module('Plan Onboarding - condition for START sprint button onboarding', {
        setup: function setup() {
            common.setup();
        },
        teardown: function teardown() {
            common.teardown();
        }
    });

    test('happy path', function () {
        BacklogModel.setData({ issues: [], sprints: [{ id: 1, name: 'Sprint 2', state: 'FUTURE' }] });
        planOnboarding.renderOnboarding();
        var buttonElement = AJS.$('.js-sprint-start');
        ok(buttonElement.hasClass('aui-button-primary'));
    });

    test('no permission', function () {
        AJS.$('.js-sprint-start').addClass('aui-button-primary');
        BacklogModel.setData({ issues: [], sprints: [{ id: 1, name: 'Sprint 2', state: 'FUTURE' }] });
        BacklogModel.canManageSprints.returns(false);
        planOnboarding.renderOnboarding();
        var buttonElement = AJS.$('.js-sprint-start');
        ok(!buttonElement.hasClass('aui-button-primary'));
    });

    test('no future sprints', function () {
        AJS.$('.js-sprint-start').addClass('aui-button-primary');
        BacklogModel.setData({ issues: [], sprints: [{ id: 1, name: 'Sprint 2', state: 'ACTIVE' }] });
        planOnboarding.renderOnboarding();
        var buttonElement = AJS.$('.js-sprint-start');
        ok(!buttonElement.hasClass('aui-button-primary'));
    });

    test('no issues in future sprints', function () {
        AJS.$('.js-sprint-start').addClass('aui-button-primary');
        BacklogModel.setData({ issues: [], sprints: [{ id: 1, name: 'Sprint 2', state: 'FUTURE' }] });
        GH.SprintView.calculateSprintIssueListStats.returns({ totalCount: 0 });
        planOnboarding.renderOnboarding();
        var buttonElement = AJS.$('.js-sprint-start');
        ok(!buttonElement.hasClass('aui-button-primary'));
    });

    module('Plan Onboarding - condition for "Plan your sprint" message', {
        setup: function setup() {
            common.setup();
            AJS.$('#qunit-fixture').append('<div class="js-sprint-container" data-sprint-id=2><div class="js-sprint-start"></div><div class="ghx-helper"></div></div></div>');
            AJS.$('#qunit-fixture').append('<meta name="ajs-onboarding-has-completed-first-use-flow" content="true" />');
            GH.SprintView.calculateSprintIssueListStats.returns({ totalCount: 0 });
        },
        teardown: function teardown() {
            common.teardown();
        }
    });

    test('with one future sprint', function () {
        BacklogModel.setData({ issues: [], sprints: [{ id: 1, name: 'Second Sprint', state: 'FUTURE' }] });
        planOnboarding.renderOnboarding();
        var sprints = AJS.$('.js-sprint-container');
        equal(sprints.eq(0).find('.ghx-onboarding-planyoursprint').length, 1);
    });

    test('with two future sprints', function () {
        BacklogModel.setData({ issues: [], sprints: [{ id: 1, name: 'Second Sprint', state: 'FUTURE' }, { id: 2, name: 'Sprint Three', state: 'FUTURE' }] });
        planOnboarding.renderOnboarding();
        var sprints = AJS.$('.js-sprint-container');
        equal(sprints.length, 2);
        equal(sprints.eq(0).find('.ghx-onboarding-planyoursprint').length, 1);
        equal(sprints.eq(1).find('.ghx-onboarding-planyoursprint').length, 0, 'message should only ever render in the first sprint if it is a future sprint');
    });

    test('future sprint with issue in it', function () {
        BacklogModel.setData({ issues: [], sprints: [{ id: 1, name: 'Second Sprint', state: 'FUTURE' }, { id: 2, name: 'Sprint Three', state: 'FUTURE' }] });
        GH.SprintView.calculateSprintIssueListStats.returns({ totalCount: 1 });
        planOnboarding.renderOnboarding();
        var sprints = AJS.$('.js-sprint-container');
        equal(sprints.length, 2);
        equal(sprints.eq(0).find('.ghx-onboarding-planyoursprint').length, 0, 'message should only render if there are no issues in the sprint');
        equal(sprints.eq(1).find('.ghx-onboarding-planyoursprint').length, 0, 'message should only ever render in the first sprint if it is a future sprint');
    });

    test('future sprint after active', function () {
        BacklogModel.setData({ issues: [], sprints: [{ id: 1, name: 'Second Sprint', state: 'ACTIVE' }, { id: 2, name: 'Sprint Three', state: 'FUTURE' }] });
        planOnboarding.renderOnboarding();
        var planSprintMessage = AJS.$('.ghx-onboarding-planyoursprint');
        equal(planSprintMessage.length, 0, 'message should only ever render in the first sprint if it is a future sprint');
    });

    test('no future sprints', function () {
        BacklogModel.setData({ issues: [], sprints: [{ id: 1, name: 'Second Sprint', state: 'ACTIVE' }, { id: 2, name: 'Sprint Three', state: 'ACTIVE' }] });
        planOnboarding.renderOnboarding();
        var planSprintMessage = AJS.$('.ghx-onboarding-planyoursprint');
        equal(planSprintMessage.length, 0, 'message should only ever render in the first sprint if it is a future sprint');
    });

    test('no sprints', function () {
        BacklogModel.setData({ issues: [], sprints: [] });
        planOnboarding.renderOnboarding();
        var planSprintMessage = AJS.$('.ghx-onboarding-planyoursprint');
        equal(planSprintMessage.length, 0, 'message should only ever render in the first sprint if it is a future sprint');
    });

    test('no permission', function () {
        BacklogModel.setData({ issues: [], sprints: [{ id: 1, name: 'Second Sprint', state: 'FUTURE' }] });
        BacklogModel.canManageSprints.returns(false);
        planOnboarding.renderOnboarding();
        var planSprintMessage = AJS.$('.ghx-onboarding-planyoursprint');
        equal(planSprintMessage.length, 0, 'message should only ever render in the first sprint if it is a future sprint');
    });

    module('Plan Onboarding - Backlog messages', {
        setup: function setup() {
            common.setup();
            sinon.stub(BacklogModel, 'canCreateIssue');
            BacklogModel.canCreateIssue.returns(true);

            appendBacklogMessageContainers(AJS.$('#qunit-fixture'));
        },
        teardown: function teardown() {
            BacklogModel.canCreateIssue.restore();
            common.teardown();
        }
    });

    test('No issues, no sprints and can create issue shows fill backlog', function () {
        BacklogModel.setData({ issues: [], sprints: [] });
        planOnboarding.renderOnboarding();

        var backlogMessage = AJS.$('.ghx-onboarding-fillyourbacklog-group .ghx-onboarding-message');
        equal(backlogMessage.length, 1, 'Should have a backlog fill message');

        var planSprintMessage = AJS.$('.ghx-backlog-group .ghx-helper');
        ok(!planSprintMessage.is(':visible'), 'Shold not have an empty message for backlog');
    });

    test('No issues, no sprints and cannot create issue shows empty message', function () {
        BacklogModel.setData({ issues: [], sprints: [] });
        BacklogModel.canCreateIssue.returns(false);
        planOnboarding.renderOnboarding();

        var backlogMessage = AJS.$('.ghx-onboarding-fillyourbacklog-group .ghx-onboarding-message');
        equal(backlogMessage.length, 0, 'Should not have a backlog fill message');

        var planSprintMessage = AJS.$('.ghx-backlog-group .ghx-helper');
        ok(planSprintMessage.is(':visible'), 'Shold not have an empty message for backlog');
    });

    test('No issues, a sprint and can create issue only shows empty message', function () {
        BacklogModel.setData({ issues: [], sprints: [{ id: 1, name: 'Sprint 2', state: 'FUTURE' }] });
        planOnboarding.renderOnboarding();

        var backlogMessage = AJS.$('.ghx-onboarding-fillyourbacklog-group .ghx-onboarding-message');
        equal(backlogMessage.length, 0, 'Should not have a backlog fill message');

        var planSprintMessage = AJS.$('.ghx-backlog-group .ghx-helper');
        ok(planSprintMessage.is(':visible'), 'Shold not have an empty message for backlog');
    });

    test('An issue, no sprint and can create issue only shows backlog fill message message', function () {
        BacklogModel.setData({ issues: [], sprints: [] });
        BacklogModel.issueListStats = {
            totalCount: 1
        };
        planOnboarding.renderOnboarding();

        var backlogMessage = AJS.$('.ghx-onboarding-fillyourbacklog-group .ghx-onboarding-message');
        equal(backlogMessage.length, 1, 'Should not have a backlog fill message');

        var planSprintMessage = AJS.$('.ghx-backlog-group .ghx-helper');
        ok(!planSprintMessage.is(':visible'), 'Shold not have an empty message for backlog');
    });

    test('An issue, a sprint and can create issue shows no message', function () {
        BacklogModel.setData({ issues: [{ id: 2, name: 'issue' }], sprints: [{ id: 1, name: 'Sprint 2', state: 'FUTURE' }] });

        var issueRenderData = { hiddenIssues: {}, selectedIssueKeys: {} };
        SprintBacklogView.renderBacklog(issueRenderData);
        planOnboarding.renderOnboarding();

        var backlogMessage = AJS.$('.ghx-onboarding-fillyourbacklog-group .ghx-onboarding-message');
        equal(backlogMessage.length, 0, 'Should not have a backlog fill message');

        var planSprintMessage = AJS.$('.ghx-backlog-group .ghx-helper');
        ok(!planSprintMessage.is(':visible'), 'Shold not have an empty message for backlog');
    });

    test('3 issues, no sprint and can create issue shows no messages', function () {
        BacklogModel.setData({ issues: [{ id: 2, name: 'issue', key: 'AS1' }, { id: 3, name: 'issue2', key: 'AS2' }, { id: 4, name: 'issue3', key: 'AS3' }], sprints: [] });

        var issueRenderData = { hiddenIssues: {}, selectedIssueKeys: {} };
        SprintBacklogView.renderBacklog(issueRenderData);
        planOnboarding.renderOnboarding();

        var backlogMessage = AJS.$('.ghx-onboarding-fillyourbacklog-group .ghx-onboarding-message');
        equal(backlogMessage.length, 0, 'Should not have a backlog fill message');

        var planSprintMessage = AJS.$('.ghx-backlog-group .ghx-helper');
        ok(!planSprintMessage.is(':visible'), 'Should not have an empty message for backlog');
    });

    test('3 issues none visible, no sprint and can create issue shows no messages', function () {
        BacklogModel.setData({ issues: [{ id: 2, name: 'issue', key: 'AS1', hidden: true }, { id: 3, name: 'issue2', key: 'AS2', hidden: true }, { id: 4, name: 'issue3', key: 'AS3', hidden: true }], sprints: [] });

        planOnboarding.renderOnboarding();

        var backlogMessage = AJS.$('.ghx-onboarding-fillyourbacklog-group .ghx-onboarding-message');
        equal(backlogMessage.length, 0, 'Should not have a backlog fill message');

        var planSprintMessage = AJS.$('.ghx-backlog-group .ghx-helper');
        ok(planSprintMessage.is(':visible'), 'Should not have an empty message for backlog');
    });

    module('Plan Onboarding - Events', {
        setup: function setup() {
            common.setup();
        },
        teardown: function teardown() {
            common.teardown();
        }
    });

    test('refresh event', function () {
        BacklogModel.setData({ issues: [], sprints: [{ id: 1, name: 'Sprint 2', state: 'FUTURE' }] });
        ok(!common.events.onRefresh.called);
        planOnboarding.refresh();
        ok(common.events.onRefresh.calledOnce);
    });
});