AJS.test.require("com.pyxis.greenhopper.jira:gh-rapid", function () {
    var PlanIssueListView = require('jira-agile/rapid/ui/plan/plan-issue-list-view');
    var PlanIssueListView = require('jira-agile/rapid/ui/plan/plan-issue-list-view');
    var $ = require('jquery');

    var ISSUE_SELECTOR = '.js-issue';
    var PARENT_ISSUE_SELECTOR = '.ghx-parent-group:not(.js-fake-parent)';
    var FAKE_PARENT_SELECTOR = '.js-fake-parent';
    var DROP_ZONE_SELECTOR = '.ghx-plan-dropzone';

    test("module 'jira-agile/rapid/ui/plan/plan-issue-list-view' exists", function () {
        ok(PlanIssueListView);
        ok(GH.PlanIssueListView);
    });

    module('PlanIssueListView', {
        setup: function () {
            var config = {
                issueKeys: [],
                issues: [
                    {
                        key: 'P-1'
                    },
                    {
                        key: 'P-2'
                    },
                    {
                        key: 'P-3',
                        subtasksCount:2,
                        subTasks: [
                            {
                                key: 'S-4'
                            },
                            {
                                key: 'S-5'
                            }
                        ]
                    },
                    {
                        key: 'P-6',
                        fakeParent: true,
                        subTasks: [
                            {
                                key: 'S-7'
                            },
                            {
                                key: 'S-8'
                            },
                            {
                                key: 'S-9'
                            }
                        ]
                    }
                ],
                epics: [],
                issueRenderData: {
                    selectedIssueKeys: [],
                    mainSelectedIssue: null,
                    hiddenIssues: []
                },
                statLabel: '',
                isRankable: true,
                showEpic: true
            };

            var $body = $('#qunit-fixture');

            var $resultDOM;
            var $rankable;

            this.given = {};

            /**
             * Given that the real parent is added back to the container in the last position.
             * When ranking this newly added issue, we should ensure we do not count the 'fake parent' as a valid rankable.
             */
            this.given.realParentAddedToContainer = function () {
                config.issues.push({key: 'P-6'});
            };

            this.when = {};

            this.when.issueListRendered = function () {
                var result = GH.tpl.planissuelist.renderIssueList(config);
                $resultDOM = $body.html(result);
                return $resultDOM;
            };

            this.when.findPrevRankableElementOf = function (issueKey) {
                var $issue = getRankingElementForIssueKey($body, issueKey);
                $rankable = PlanIssueListView.findPrevRankableElement($issue);
            };

            this.when.findNextRankableElementOf = function (issueKey) {
                var $issue = getRankingElementForIssueKey($body, issueKey);
                $rankable = PlanIssueListView.findNextRankableElement($issue);
            };

            this.varify = {};

            this.varify.hasCorrectNumberOfIssueElements = function () {
                equal($resultDOM.children().not(DROP_ZONE_SELECTOR).length, config.issues.length, 'Expected DOM to contain correct number of issues');
            };

            this.varify.prevRankableElementIs = function (issueKey) {
                equal(PlanIssueListView.getRankableId($rankable), issueKey, 'Expected rankable id to match given id');
            };

            this.varify.nextRankableElementIs = this.varify.prevRankableElementIs;
        }
    });

    function getRankingElementForIssueKey ($context, issueKey) {
        var withIssueKeyData = function () {
            return '[data-issue-key=' + issueKey + ']';
        };
        var withFakeParentIssueKeyData = function () {
            return '[data-fake-parent-issue-key=' + issueKey + ']';
        };

        return $context.find(PARENT_ISSUE_SELECTOR + withIssueKeyData() + ', ' +
            FAKE_PARENT_SELECTOR + withFakeParentIssueKeyData() + ', ' +
            ISSUE_SELECTOR + withIssueKeyData());
    }

    test('render simple', function () {
        var $resultDOM = this.when.issueListRendered();

        this.varify.hasCorrectNumberOfIssueElements();

        equal($resultDOM.children(ISSUE_SELECTOR).length, 2, '2 issues without sub-tasks');

        equal($resultDOM.children(PARENT_ISSUE_SELECTOR).find(ISSUE_SELECTOR).length, 3, '3 issues = 1 parent + 2 sub-tasks');

        equal($resultDOM.children(PARENT_ISSUE_SELECTOR).find('.ghx-subtask-group').length, 1, 'sub-task group exists');

        equal($resultDOM.children(FAKE_PARENT_SELECTOR).find(ISSUE_SELECTOR).length, 3, 'fake parent + 3 sub-tasks');
    });

    test('findPrevRankableElement for basic issue ranking', function () {
        this.when.issueListRendered();

        this.when.findPrevRankableElementOf('P-3');

        this.varify.prevRankableElementIs('P-2');
    });

    test('findNextRankableElement for basic issue ranking', function () {
        this.when.issueListRendered();

        this.when.findNextRankableElementOf('P-1');

        this.varify.nextRankableElementIs('P-2');
    });

    test('findPrevRankableElement skips ovar subtasks for issue ranking', function () {
        this.when.issueListRendered();

        this.when.findPrevRankableElementOf('P-6');

        this.varify.prevRankableElementIs('P-3'); // skips ovar subtasks S-5, S-4
    });

    test('findNextRankableElement skips ovar subtasks for issue ranking', function () {
        this.when.issueListRendered();

        this.when.findNextRankableElementOf('P-3');

        this.varify.nextRankableElementIs('P-6'); // skips ovar subtasks S-4, S-5
    });


    test('When a real parent is added to the bottom of the container,' +
        'the fake parent group sitting above it should not given as the prevRankableElement.', function () {
        this.given.realParentAddedToContainer();

        this.when.issueListRendered();

        this.when.findPrevRankableElementOf('P-6');

        this.varify.prevRankableElementIs('P-3'); // skips ovar subtasks S-5, S-4, as well as the fake parent group of P-6. (see the setup methods).
    });

    module('PlanIssueListView - rendering issue count', {
        setup: function () {
            this.ajsFormatStub = sinon.spy(AJS, 'format');
        },

        teardown: function () {
            this.ajsFormatStub.restore();
        },

        render: function (stats) {
            this.rendered = $(GH.tpl.planissuelist.renderIssueCount({
                issueListStats: stats
            }));
            this.rendered.appendTo('#qunit-fixture');
        },

        hasClearAll: function () {
            return this.rendered.find('.js-clear-all-filters').length === 1;
        }


    });

    test('If excludeSubtask is false then values from total and visible count are used', function () {
        var stats = {
            totalCount: 1,
            visibleCount: 0,
            statisticsFieldTotal: 10,
            statisticsFieldVisible: 5,
            allVisible: true
        };

        this.render(stats);

        ok(!this.hasClearAll());
        this.ajsFormatStub.calledWithExactly('gh.boards.issues2', 1);
    });

    test('If excludeSubtask is false and allVisible is false then should display filtered message', function () {
        var stats = {
            totalCount: 1,
            visibleCount: 0,
            statisticsFieldTotal: 10,
            statisticsFieldVisible: 5,
            allVisible: false
        };

        this.render(stats);

        ok(this.hasClearAll());
        this.ajsFormatStub.calledWithExactly('gh.boards.issues2.visible', 1, 0);
    });

    test('If excludeSubtask is true should use statistics fields', function () {
        var stats = {
            totalCount: 1,
            visibleCount: 0,
            statisticsFieldTotal: 10,
            statisticsFieldVisible: 5,
            subtasksTotal: 4,
            subtasksVisible: 3,
            allVisible: true
        };

        this.render(stats);

        ok(!this.hasClearAll());
        this.ajsFormatStub.calledWithExactly('gh.boards.issues2.subtasks', 10, 4);
    });

    test('ExcludeSubtasks - only issues are filtered', function () {
        var stats = {
            totalCount: 1,
            visibleCount: 0,
            statisticsFieldTotal: 10,
            statisticsFieldVisible: 5,
            subtasksTotal: 4,
            subtasksVisible: 4,
            allVisible: false
        };

        this.render(stats);

        ok(this.hasClearAll());
        this.ajsFormatStub.calledWithExactly('gh.boards.issues2.visible.issues.filtered', 10, 5, 4);
    });

    test('ExcludeSubtasks - only subtasks are filtered', function () {
        var stats = {
            totalCount: 1,
            visibleCount: 0,
            statisticsFieldTotal: 10,
            statisticsFieldVisible: 10,
            subtasksTotal: 4,
            subtasksVisible: 3,
            allVisible: false
        };

        this.render(stats);

        ok(this.hasClearAll());
        this.ajsFormatStub.calledWithExactly('gh.boards.issues2.visible.subtasks.filtered', 10, 4, 3);
    });

    test('ExcludeSubtasks - everything is filtered', function () {
        var stats = {
            totalCount: 1,
            visibleCount: 0,
            statisticsFieldTotal: 10,
            statisticsFieldVisible: 5,
            subtasksTotal: 4,
            subtasksVisible: 3,
            allVisible: false
        };

        this.render(stats);

        ok(this.hasClearAll());
        this.ajsFormatStub.calledWithExactly('gh.boards.issues2.visible.all', 10, 5, 4, 3);
    });
});