AJS.namespace("GH.PersistentMessages.CreateViewMessage");

/**
 * The message shown after creating a view.
 */
GH.PersistentMessages.CreateViewMessage = {};

/**
 * Set the view information to be displayed in the message.
 */
GH.PersistentMessages.CreateViewMessage.setView = function(id, name, type, subType) {
    var o = {'id': id, 'name': name, 'type' : type, 'subType' : subType};
    GH.storage.put('gh.createViewMessage', o, true);
};

/**
 * Clear the message from storage.
 */
GH.PersistentMessages.CreateViewMessage.clear = function() {
    GH.storage.put('gh.createViewMessage', null, true);
};

/**
 * Render the message if it exists.
 */
GH.PersistentMessages.CreateViewMessage.renderMessage = function(event) {
    if(event) {
        GH.log(event.type + " handled", "GH.PersistentMessages.CreateViewMessage.renderMessage");
    }
    var view = GH.storage.get('gh.createViewMessage', true);
    if (view) {
        var body = null;
        // escape names
        view.name = AJS.escapeHTML(String(view.name));
        var renderFunction;
        if (view.type == 'advanced') {
            renderFunction = GH.tpl.board.x.renderCreateViewMessage;
        } else if (view.subType == 'kanban') {
            renderFunction = GH.tpl.board.x.renderWelcomeViewMessageKanban;
        } else if (view.subType == 'scrum') {
            renderFunction = GH.tpl.board.x.renderWelcomeViewMessageScrum;
        }

        body = renderFunction({
            rapidView : view,
            url : AJS.parseUri(window.location.href)
        });

        GH.Notification.showSuccess(body, {
            title: AJS.I18n.getText('gh.rapid.welcome.success.title'),
            timeout: 10000
        });

        // clear the message from storage
        GH.PersistentMessages.CreateViewMessage.clear();
    }
};
