var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

define('jira-agile/rapid/ui/kanplan/KanplanEpicsInlineDialog', ['jquery', 'jira-help-tips/feature/help-tip', 'jira/util/formatter', 'jira-agile/rapid/ui/kanplan/kan-plan-feature-service', 'underscore'], function ($, HelpTip, formatter, KanPlanFeatureService, _) {
    'use strict';

    var PLAN_MODE = 'plan';
    var WORK_MODE = 'work';
    var TITLE = formatter.I18n.getText("gh.boards.kanplan.work.epics.inlinedialog.title");
    var WORK_TEXT = formatter.I18n.getText("gh.boards.kanplan.work.epics.inlinedialog.text");
    var WORK_NEXT = formatter.I18n.getText("gh.boards.kanplan.work.epics.inlinedialog.button.next");
    var WORK_CANCEL = formatter.I18n.getText("gh.boards.kanplan.work.epics.inlinedialog.button.cancel");
    var PLAN_TEXT_ADMIN = formatter.I18n.getText("gh.boards.kanplan.plan.epics.inlinedialog.text.admin");
    var PLAN_TEXT_USER = formatter.I18n.getText("gh.boards.kanplan.plan.epics.inlinedialog.text.user");
    var PLAN_NEXT = formatter.I18n.getText("gh.boards.kanplan.plan.epics.inlinedialog.button.next");
    var PLAN_CANCEL = formatter.I18n.getText("gh.boards.kanplan.plan.epics.inlinedialog.button.cancel");

    var ANALYTICS_ON_WORK_MODE = Object.freeze({
        TAKE_ME_THERE: 'jira-software.kanplan.epics.onboarding.on.work.mode.takemethere.clicked',
        NO_THANKS: 'jira-software.kanplan.epics.onboarding.on.work.mode.nothanks.clicked',
        SHOWN: 'jira-software.kanplan.epics.onboarding.on.work.mode.shown'
    });
    var ANALYTICS_ON_PLAN_MODE = Object.freeze({
        OK_GOT_IT: 'jira-software.kanplan.epics.onboarding.on.plan.mode.okgotit.clicked',
        LET_ME_CHANGE_THIS: 'jira-software.kanplan.epics.onboarding.on.plan.mode.letmechangethis.clicked',
        SHOWN: 'jira-software.kanplan.epics.onboarding.on.plan.mode.shown'
    });

    var EpicsInlineDialog = function () {
        function EpicsInlineDialog(options) {
            _classCallCheck(this, EpicsInlineDialog);

            this.mode = options.mode;
            this.isEpicsPanelOpen = options.epicsPanelState;
            this.epicsCount = options.epicsCount;

            var shownEventName = this.mode === WORK_MODE ? ANALYTICS_ON_WORK_MODE.SHOWN : ANALYTICS_ON_PLAN_MODE.SHOWN;
            KanPlanFeatureService.sendAnalyticsInfo(shownEventName, this.extraEventAttributes(), true);
        }

        _createClass(EpicsInlineDialog, [{
            key: 'render',
            value: function render() {
                this.dialog = this.createDialog();
                this.dialog.show();
                this.dialog.refresh();
            }
        }, {
            key: 'hide',
            value: function hide() {
                if (this.dialog) {
                    this.dialog.view.dismiss();
                }
            }
        }, {
            key: 'createDialog',
            value: function createDialog() {
                var _this = this;

                var defaults = {
                    inlineDialogOpts: {
                        gravity: 'w',
                        offsetY: 50
                    },
                    callbacks: {
                        init: function init() {
                            //init events only after HelpTip is rendered
                            _this.bindEvents();
                        }
                    }
                };

                return new HelpTip(_.extend(defaults, this.getOptionsForMode()));
            }
        }, {
            key: 'bindEvents',
            value: function bindEvents() {
                var _this2 = this;

                var $dialogContainer = this.dialog.view.$el;

                $dialogContainer.find('.helptip-next').on('click', function () {
                    _this2.nextHandler();
                });

                $dialogContainer.find('.helptip-close').on('click', function () {
                    _this2.closeHandler();
                });
            }
        }, {
            key: 'getOptionsForMode',
            value: function getOptionsForMode() {
                if (this.mode === WORK_MODE) {
                    return {
                        title: TITLE,
                        bodyHtml: WORK_TEXT,
                        anchor: $('.aui-icon.agile-icon-plan').closest('a'),
                        showNextButton: true,
                        nextButtonText: WORK_NEXT,
                        showCloseButton: true,
                        closeButtonText: WORK_CANCEL,
                        inlineDialogOpts: {
                            offsetY: 105,
                            arrowOffsetY: -60,
                            gravity: 'w'
                        }
                    };
                } else {
                    return {
                        title: TITLE,
                        bodyHtml: this.getTextForPlanMode(),
                        anchor: this.getAnchor(),
                        showNextButton: true,
                        nextButtonText: PLAN_NEXT,
                        showCloseButton: this.isBoardAdmin(),
                        closeButtonText: PLAN_CANCEL
                    };
                }
            }
        }, {
            key: 'getAnchor',
            value: function getAnchor() {
                return this.isEpicsPanelOpen ? $('#ghx-epic-column .ghx-classification-header') : $('.js-epic-toggle');
            }
        }, {
            key: 'getTextForPlanMode',
            value: function getTextForPlanMode() {
                if (this.isBoardAdmin()) {
                    return PLAN_TEXT_ADMIN;
                } else {
                    return PLAN_TEXT_ADMIN.concat('<br/>', PLAN_TEXT_USER);
                }
            }
        }, {
            key: 'isBoardAdmin',
            value: function isBoardAdmin() {
                //The user is a board admin (or global admin)
                return GH.UserData.userConfig.isGlobalAdmin || GH.RapidViewConfig.isBoardAdmin;
            }
        }, {
            key: 'nextHandler',
            value: function nextHandler() {
                var _this3 = this;

                KanPlanFeatureService.dismissEpicsOnboardingDialog().done(function () {
                    if (_this3.mode === WORK_MODE) {
                        GH.RapidBoard.ViewController.setMode('plan');
                        KanPlanFeatureService.sendAnalyticsInfo(ANALYTICS_ON_WORK_MODE.TAKE_ME_THERE, _this3.extraEventAttributes(), true);
                    } else {
                        KanPlanFeatureService.sendAnalyticsInfo(ANALYTICS_ON_PLAN_MODE.OK_GOT_IT, _this3.extraEventAttributes(), true);
                    }
                });
            }
        }, {
            key: 'closeHandler',
            value: function closeHandler() {
                var _this4 = this;

                KanPlanFeatureService.dismissEpicsOnboardingDialog().done(function () {
                    if (_this4.mode === PLAN_MODE) {
                        // If the timeout is not there the page will redirect while the dialog is being hidden, leaving an awkward ghost dialog
                        setTimeout(function () {
                            GH.RapidBoard.gotoRapidViewConfiguration(GH.RapidBoard.State.getRapidViewId(), 'columns');
                        }, 0);
                        KanPlanFeatureService.sendAnalyticsInfo(ANALYTICS_ON_PLAN_MODE.LET_ME_CHANGE_THIS, _this4.extraEventAttributes(), true);
                    } else {
                        KanPlanFeatureService.sendAnalyticsInfo(ANALYTICS_ON_WORK_MODE.NO_THANKS, _this4.extraEventAttributes(), true);
                    }
                });
            }
        }, {
            key: 'updatePosition',
            value: function updatePosition(epicsPanelState) {
                this.isEpicsPanelOpen = epicsPanelState;
                this.dialog.dismiss();
                this.render();
            }
        }, {
            key: 'extraEventAttributes',
            value: function extraEventAttributes() {
                return {
                    epicsCount: this.epicsCount
                };
            }
        }]);

        return EpicsInlineDialog;
    }();

    return EpicsInlineDialog;
});