AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common-base", "com.pyxis.greenhopper.jira:gh-rapid", "com.pyxis.greenhopper.jira:gh-rapid-config", "com.atlassian.plugins.helptips.jira-help-tips"], function () {
    var formatter = require("jira/util/formatter");
    var KanPlanInlineDialogController = require('jira-agile/rapid/ui/kanplan/KanPlanInlineDialogController');
    var KanPlanFeatureService = require('jira-agile/rapid/ui/kanplan/kan-plan-feature-service');
    var KanPlanEpicsInlineDialog = require('jira-agile/rapid/ui/kanplan/KanplanEpicsInlineDialog');

    var asserts = [{
        title: "Valid conditions",
        isKanbanBoard: true,
        isKanbanBacklogMapped: false,
        isKanPlanEnabled: true,
        isDialogDismissed: false,
        isGlobalAdmin: true,
        isBoardAdmin: true,
        columnsCount: 3,
        issuesCount: 20,
        result: true
    }, {
        title: "isKanbanBoard=false",
        isKanbanBoard: false,
        isKanbanBacklogMapped: false,
        isDarkFeatureEnabled: true,
        isDialogDismissed: false,
        isGlobalAdmin: true,
        isBoardAdmin: true,
        columnsCount: 3,
        issuesCount: 20,
        result: false
    }, {
        title: "isKanPlanAlreadyEnabled=true",
        isKanbanBoard: true,
        isKanbanBacklogMapped: true,
        isKanPlanEnabled: true,
        isDialogDismissed: false,
        isGlobalAdmin: true,
        isBoardAdmin: true,
        columnsCount: 3,
        issuesCount: 20,
        result: false
    }, {
        title: "isKanPlanEnabled=false",
        isKanbanBoard: true,
        isKanbanBacklogMapped: false,
        isKanPlanEnabled: false,
        isDialogDismissed: false,
        isGlobalAdmin: true,
        isBoardAdmin: true,
        columnsCount: 3,
        issuesCount: 20,
        result: false
    }, {
        title: "isDialogDismissed=true",
        isKanbanBoard: true,
        isKanbanBacklogMapped: false,
        isKanPlanEnabled: true,
        isDialogDismissed: true,
        isGlobalAdmin: true,
        isBoardAdmin: true,
        columnsCount: 3,
        issuesCount: 20,
        result: false
    }, {
        title: "isGlobalAdmin=false",
        isKanbanBoard: true,
        isKanbanBacklogMapped: false,
        isKanPlanEnabled: true,
        isDialogDismissed: false,
        isGlobalAdmin: false,
        isBoardAdmin: true,
        columnsCount: 3,
        issuesCount: 20,
        result: true
    }, {
        title: "isBoardAdmin=false",
        isKanbanBoard: true,
        isKanbanBacklogMapped: false,
        isKanPlanEnabled: true,
        isDialogDismissed: false,
        isGlobalAdmin: true,
        isBoardAdmin: false,
        columnsCount: 3,
        issuesCount: 20,
        result: true
    }, {
        title: "isBoardAdmin=false && isGlobalAdmin=false",
        isKanbanBoard: true,
        isKanbanBacklogMapped: false,
        isKanPlanEnabled: true,
        isDialogDismissed: false,
        isGlobalAdmin: false,
        isBoardAdmin: false,
        columnsCount: 3,
        issuesCount: 20,
        result: false
    }, {
        title: "columnsCount=2",
        isKanbanBoard: true,
        isKanbanBacklogMapped: false,
        isKanPlanEnabled: true,
        isDialogDismissed: false,
        isGlobalAdmin: true,
        isBoardAdmin: true,
        columnsCount: 2,
        issuesCount: 20,
        result: false
    }, {
        title: "issuesCount=3",
        isKanbanBoard: true,
        isKanbanBacklogMapped: false,
        isKanPlanEnabled: true,
        isDialogDismissed: false,
        isGlobalAdmin: true,
        isBoardAdmin: true,
        columnsCount: 3,
        issuesCount: 3,
        result: false
    }];

    /**
     *
     * @param {Object} options
     * @param {Boolean} options.isKanbanBoard
     * @param {Boolean} options.isKanPlanEnabled
     * @param {Boolean} options.isDialogDismissed
     * @param {Boolean} options.isGlobalAdmin
     * @param {Boolean} options.isBoardAdmin
     * @param {Boolean} options.isKanbanBacklogMapped
     * @param {Number} options.columnsCount
     * @param {Number} options.issuesCount
     * @returns {Object} model
     */
    function _setUpGlobals(options) {
        GH.RapidBoard.State.isKanbanBoard.returns(options.isKanbanBoard);
        KanPlanFeatureService.isFeatureEnabled.returns(options.isKanPlanEnabled);
        GH.BoardState.getPerViewValue.returns(options.isDialogDismissed);

        AJS.namespace('GH.UserData.userConfig');
        AJS.namespace('GH.RapidViewConfig');
        GH.UserData.userConfig.isGlobalAdmin = options.isGlobalAdmin;
        GH.RapidViewConfig.isBoardAdmin = options.isBoardAdmin;
        GH.RapidViewConfig.kanPlanEnabled = options.isKanbanBacklogMapped;

        this.epicsCount = options.epicsCount;

        return {
            getColumns: this.sandbox.stub().returns({
                length: options.columnsCount
            }),
            getFirstColumn: this.sandbox.stub().returns({
                id: 1
            }),
            getColumnIssueCount: this.sandbox.stub().returns(options.issuesCount)
        };
    }

    module("isVisible", {
        setup: function setup() {
            this.sandbox = sinon.sandbox.create();

            this.sandbox.stub(GH.RapidBoard.State, 'isKanbanBoard');
            this.sandbox.stub(KanPlanFeatureService, 'isFeatureEnabled');
            this.sandbox.stub(GH.BoardState, 'getPerViewValue');
        },
        teardown: function teardown() {
            this.sandbox.restore();
        },
        setUpGlobals: function setUpGlobals(options) {
            return _setUpGlobals.call(this, options);
        }
    });

    _.each(asserts, function (options) {
        test(options.title, function () {
            var data = this.setUpGlobals(options);

            var result = KanPlanInlineDialogController.isVisible(data);

            equal(result, options.result);
        });
    });

    var epicsOnboardiingAsserts = [{
        title: "Displayed for admins on board and backlog when conditions are valid",
        mode: ['work', 'plan'],
        isKanbanBoard: true,
        isKanbanBacklogMapped: true,
        isKanPlanEnabled: true,
        isClosedOnPlanMode: false,
        isClosedOnWorkMode: false,
        isGlobalAdmin: true,
        isBoardAdmin: true,
        showEpicAsPanel: true,
        epicsCount: 1,
        result: true
    }, {
        title: "Displayed for normal users on board and backlog when conditions are valid",
        mode: ['work', 'plan'],
        isKanbanBoard: true,
        isKanbanBacklogMapped: true,
        isKanPlanEnabled: true,
        isClosedOnPlanMode: false,
        isClosedOnWorkMode: false,
        isGlobalAdmin: false,
        isBoardAdmin: false,
        showEpicAsPanel: true,
        epicsCount: 1,
        result: true
    }, {
        title: "Not displayed when Kanplan featureflag is disabled",
        mode: ['work', 'plan'],
        isKanbanBoard: true,
        isKanbanBacklogMapped: true,
        isKanPlanEnabled: false,
        isClosedOnPlanMode: false,
        isClosedOnWorkMode: false,
        isGlobalAdmin: true,
        isBoardAdmin: true,
        showEpicAsPanel: true,
        epicsCount: 1,
        result: false
    }, {
        title: "Not displayed when no status is mapped to kanplan backlog",
        mode: ['work', 'plan'],
        isKanbanBoard: true,
        isKanbanBacklogMapped: false,
        isKanPlanEnabled: true,
        isClosedOnPlanMode: false,
        isClosedOnWorkMode: false,
        isGlobalAdmin: true,
        isBoardAdmin: true,
        showEpicAsPanel: true,
        epicsCount: 1,
        result: false
    }, {
        title: "Not displayed on workmode when dismissed from backlog",
        mode: ['work'],
        isKanbanBoard: true,
        isKanbanBacklogMapped: true,
        isKanPlanEnabled: true,
        isClosedOnPlanMode: true,
        isClosedOnWorkMode: false,
        isGlobalAdmin: true,
        isBoardAdmin: true,
        showEpicAsPanel: true,
        epicsCount: 1,
        result: false
    }, {
        title: "Not displayed on scrumboard",
        mode: ['work', 'plan'],
        isKanbanBoard: false,
        isKanbanBacklogMapped: true,
        isKanPlanEnabled: true,
        isClosedOnPlanMode: false,
        isClosedOnWorkMode: false,
        isGlobalAdmin: true,
        isBoardAdmin: true,
        showEpicAsPanel: true,
        epicsCount: 1,
        result: false
    }, {
        title: "Not displayed  when epic switch is off",
        mode: ['work', 'plan'],
        isKanbanBoard: true,
        isKanbanBacklogMapped: true,
        isKanPlanEnabled: true,
        isClosedOnPlanMode: false,
        isClosedOnWorkMode: false,
        isGlobalAdmin: true,
        isBoardAdmin: true,
        showEpicAsPanel: false,
        epicsCount: 1,
        result: false
    }, {
        title: "Not displayed when there are no epics",
        mode: ['work', 'plan'],
        isKanbanBoard: true,
        isKanbanBacklogMapped: true,
        isKanPlanEnabled: true,
        isClosedOnPlanMode: false,
        isClosedOnWorkMode: false,
        isGlobalAdmin: true,
        isBoardAdmin: true,
        showEpicAsPanel: true,
        epicsCount: 0,
        result: false
    }];

    module("isEpicsOnboardingVisible", {
        setup: function setup() {
            var _this = this;

            this.sandbox = sinon.sandbox.create();

            this.sandbox.stub(GH.RapidBoard.State, 'isKanbanBoard');
            this.sandbox.stub(KanPlanFeatureService, 'isFeatureEnabled');
            this.sandbox.stub(GH.BoardState, 'getPerViewValue');
            this.sandbox.stub(KanPlanEpicsInlineDialog.prototype, 'render');
            var self = this;
            this.sandbox.stub(GH.EpicController, 'getEpicModel', function () {
                return {
                    getEpicList: function getEpicList() {
                        return {
                            getIssueCount: function getIssueCount() {
                                return self.epicsCount;
                            }
                        };
                    }
                };
            });
            this.sandbox.stub(GH.GridDataController, 'getEpicsCount', function () {
                return _this.epicsCount;
            });
        },
        teardown: function teardown() {
            this.sandbox.restore();
        },
        setUpGlobals: function setUpGlobals(options) {
            _setUpGlobals.call(this, options);
        }
    });

    _.each(epicsOnboardiingAsserts, function (options) {
        test(options.title, function () {
            this.setUpGlobals(options);
            this.sandbox.stub(GH.RapidBoard.State, 'getShowEpicAsPanel').returns(options.showEpicAsPanel);

            KanPlanFeatureService.updateKanplanEpicsOnboardingState('work', options.isClosedOnWorkMode);
            KanPlanFeatureService.updateKanplanEpicsOnboardingState('plan', options.isClosedOnPlanMode);
            if (options.mode && !_.isArray(options.mode)) {
                options.mode = [options.mode];
            }
            _.each(options.mode, function (mode) {
                var result = KanPlanInlineDialogController.shouldShowEpicsOnboarding(mode);
                equal(result, options.result);
            });
        });
    });
});