AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common","com.pyxis.greenhopper.jira:gh-rapid"],function(){var s=require("jira-agile/rapid/ui/plan/backlog-controller"),e=require("jira-agile/rapid/ui/plan/backlog-model");module("handleIssueCreated",{setup:function(){this.sandbox=sinon.sandbox.create(),this.context=AJS.test.mockableModuleContext(),this.context.mock("jira-agile/rapid/ui/plan/analytics-helper",{baseEventData:sinon.stub().returns({})}),this.logger={trace:sinon.stub()},this.context.mock("jira/util/logger",this.logger),this.EpicController=this.context.require("jira-agile/rapid/ui/epic/epic-controller"),GH.Test.setUpFakeServer(this),GH.AnalyticsEnabled=!0,this.fakeEpic={issueKey:1,fields:{issuetype:{name:"Epic"}}},GH.EpicConfig.epicConfig={epicStatusFieldId:1}},teardown:function(){GH.Notification.clear(),GH.Test.restoreServer(this),this.sandbox.restore()}}),test("Successful Ajax request triggers the analytics",sinon.test(function(){this.stub(this.EpicController.analytics,"trigger"),this.stub(GH.EpicConfig,"getEpicLabelFieldId").returns("customfield_1"),GH.Test.respondToBareUrlGetWith200(this,"/rest/api/2/issue/",this.fakeEpic),this.EpicController.handleIssueCreated(null,{issues:[{issueKey:1}]}),this.server.respond(),ok(this.EpicController.analytics.trigger.called,"Called success method")})),test("Failed request does not trigger analytics (no specific error handling)",sinon.test(function(){this.stub(this.EpicController.analytics,"trigger"),this.stub(GH.EpicConfig,"getEpicLabelFieldId").returns("customfield_1"),GH.Test.respondToBareUrlGetWith500(this,"/rest/api/2/issue/",{}),this.EpicController.handleIssueCreated(null,{issues:[{issueKey:1}]}),this.server.respond(),ok(!this.EpicController.analytics.trigger.called,"Does not trigger analytics on failure")})),test("addIssuesToEpic: should show proper success message",sinon.test(function(){var s="epic1",e=["issue-key1","issue-key2","issue-key3"],t=this.logger.trace,i=this.sandbox.stub(GH.Notification,"showSuccess");this.sandbox.stub(this.EpicController,"addIssuesToEpicOnServer").returns(AJS.$.Deferred().resolve().promise()),this.sandbox.stub(GH.BacklogModel,"getIssueData",function(s){return{key:s,typeId:"random-id-which-must-be-different-than-epic-issue-type-id"}});var o=[{countIssues:0,expectedArgs:["gh.epic.issues.added",0,void 0,void 0]},{countIssues:1,expectedArgs:["gh.epic.issues.added",1,"issue-key1",void 0]},{countIssues:2,expectedArgs:["gh.epic.issues.added",2,"issue-key1","issue-key2"]},{countIssues:3,expectedArgs:["gh.epic.issues.added",3,"issue-key1","issue-key2"]}];o.forEach(function(o){this.EpicController.addIssuesToEpic(s,e.slice(0,o.countIssues)),ok(t.calledWithExactly.apply(t,o.expectedArgs),"when countIssues="+o.countIssues+" 'getText' should be called with ["+o.expectedArgs+"]; was: ["+t.getCall(0).args+"]"),ok(i.calledOnce,"when countIssues="+o.countIssues+" 'showSuccess' should be called once"),t.reset(),i.reset()},this)})),test("removeIssuesFromAssociatedEpics: should show proper success message",sinon.test(function(){var s=["issue-key1","issue-key2","issue-key3"],e=this.logger.trace,t=this.sandbox.stub(GH.Notification,"showSuccess");this.sandbox.stub(GH.PlanController,"isActive").returns(!0),this.sandbox.stub(this.EpicController,"_reloadDetailsView").returns(),this.sandbox.stub(GH.Ajax,"put").returns(AJS.$.Deferred().resolve().promise()),this.sandbox.stub(GH.BacklogController,"updateEpicData").returns(AJS.$.Deferred().resolve().promise()),this.sandbox.stub(GH.BacklogModel,"removeEpicFromIssues",function(s){return s.map(function(s){return{key:s,typeId:"random-id-which-must-be-different-than-epic-issue-type-id"}})});var i=[{countIssues:1,expectedArgs:["gh.epic.issues.removed",1,"issue-key1",void 0]},{countIssues:2,expectedArgs:["gh.epic.issues.removed",2,"issue-key1","issue-key2"]},{countIssues:3,expectedArgs:["gh.epic.issues.removed",3,"issue-key1","issue-key2"]}];i.forEach(function(i){this.EpicController.removeIssuesFromAssociatedEpics(s.slice(0,i.countIssues)),ok(e.calledWithExactly.apply(e,i.expectedArgs),"when countIssues="+i.countIssues+" 'getText' should be called with ["+i.expectedArgs+"]; was: ["+e.getCall(0).args+"]"),ok(t.calledOnce,"when countIssues="+i.countIssues+" 'showSuccess' should be called once"),e.reset(),t.reset()},this)})),test("addIssuesToEpicOnServer: Ajax request sent and stringified",sinon.test(function(){this.EpicController.addIssuesToEpicOnServer(),ok(GH.Test.isRequestDataStringified(this.server.requests[0])),this.server.respond()})),test("addIssuesToEpicOnServer: should handle general error message when adding sub-tasks",sinon.test(function(){var s="epic1",e="issue-key";this.sandbox.stub(GH.Notification,"showErrors"),[401,403,500].forEach(function(t){GH.Test.respondWith(this,"/epics/"+s+"/add",{},"PUT",t),this.EpicController.addIssuesToEpicOnServer(s,[e]),this.server.respond(),sinon.assert.calledOnce(GH.Notification.showErrors);var i=GH.Notification.showErrors.getCall(0).args[0];strictEqual(i.errors[0].status,t,"error status should be "+t),GH.Notification.showErrors.reset()},this)})),test("addIssuesToEpicOnServer: should handle specific error message when adding sub-tasks",sinon.test(function(){var s="epic1",e="issue-key",t="should show correct error message when adding a sub-task",i={errors:{"soft-error":t},errorMessages:[]},o=!0,r={autoHide:!0,showTitle:!1};this.sandbox.stub(GH.Notification,"showErrors"),GH.Test.respondWith(this,"/epics/"+s+"/add",i,"PUT",400),this.EpicController.addIssuesToEpicOnServer(s,[e]),this.server.respond(),sinon.assert.calledOnce(GH.Notification.showErrors);var n=GH.Notification.showErrors.getCall(0).args,a=n[0],c=n[1],u=n[2];strictEqual(a.errors[0].message,t),strictEqual(c,o,"message should be closeable"),deepEqual(u,r,"message should be automatically closed and rendered without title")})),test("removeIssuesFromAssociatedEpics: Successful AJAX call reinitializes the form",sinon.test(function(){this.stub(GH.Notification,"showSuccess"),this.stub(e,"getIssueData").returns({epic:2}),GH.Test.respondToPutWith200(this,"/epics/remove",{}),this.EpicController.removeIssuesFromAssociatedEpics([1]),ok(GH.Test.isRequestDataStringified(this.server.requests[0])),this.server.respond(),ok(GH.Notification.showSuccess.called,"Called success method")})),test("removeIssuesFromAssociatedEpics: Failed AJAX call does nothing (no error handling)",sinon.test(function(){this.stub(GH.Notification,"showSuccess"),this.stub(e,"getIssueData").returns({epic:2}),GH.Test.respondToPutWith500(this,"/epics/remove",{}),this.EpicController.removeIssuesFromAssociatedEpics([1]),ok(GH.Test.isRequestDataStringified(this.server.requests[0])),this.server.respond(),ok(!GH.Notification.showSuccess.called,"Did not call success method")})),test("updateEpicAsDone: Successful AJAX call updates epic data",sinon.test(function(){this.stub(s,"updateEpicData"),GH.Test.respondToPutWith200(this,"/xboard/issue/update-field.json",{}),this.EpicController.updateEpicAsDone(10),ok(GH.Test.isRequestDataStringified(this.server.requests[0])),this.server.respond(),ok(s.updateEpicData.called,"Called success method")})),test("updateEpicAsDone: Failed AJAX call does nothing (no error handling)",sinon.test(function(){this.stub(s,"updateEpicData"),GH.Test.respondToPutWith500(this,"/xboard/issue/update-field.json",{}),this.EpicController.updateEpicAsDone(10),ok(GH.Test.isRequestDataStringified(this.server.requests[0])),this.server.respond(),ok(!s.updateEpicData.called,"Did not call success method")}))});