GH.Dialogs.ReopenSprintDialog = {};

GH.Dialogs.ReopenSprintDialog.EVENT_SPRINT_REOPENED = "sprintReopened";

GH.Dialogs.ReopenSprintDialog.analyticsMetaData = function (metaData) {
    AJS.trigger('analyticsEvent', { name: 'gh.sprint.reopen', data: metaData });
};

GH.Dialogs.ReopenSprintDialog.showDialog = function (rapidViewId, sprintId) {
    AJS.dim();
    AJS.$('.aui-blanket').html('<div class="jira-spinner-container"><aui-spinner size="medium" class="jira-page-loading-indicator"></aui-spinner></div>');

    GH.Ajax.get({
        url: '/sprint/' + sprintId + '/reopen',
        data: {
            rapidViewId: rapidViewId,
            sprintId: sprintId
        }
    }, "reopensprintdialog").done(GH.Dialogs.ReopenSprintDialog.renderDialog).fail(function () {
        AJS.undim();
        AJS.$('.aui-blanket').empty();
    });
};

/**
 * Renders the "reopen sprint" dialog
 *
 * @param {ReopenSprintViewModel} model
 */
GH.Dialogs.ReopenSprintDialog.renderDialog = function (model) {

    // create the dialog
    var dialog = GH.Dialog.create({
        width: 630,
        height: 270,
        id: 'ghx-dialog-reopen-sprint'
    });
    dialog.addHeader(AJS.I18n.getText('gh.sprint.reopen.dialog.title'));
    dialog.addPanel('', 'panel');

    if (model.issuesMovedBack !== 0) {
        var cal = new Calendar(); // GHS-5829 Need to call new calendar to set up short month names and day names when they are not defined
        dialog.getCurrentPanel().html(GH.tpl.dialogs.reopensprint.renderReopenSprintDialog({ model: model }));
        dialog.addButton(AJS.I18n.getText('gh.sprint.reopen.dialog.ok.button.label'), function () {
            dialog.disableControls();
            dialog.showSpinner();
            GH.Dialogs.ReopenSprintDialog.complete(dialog, model);
        }, 'aui-button');
    } else {
        dialog.getCurrentPanel().html(GH.tpl.dialogs.reopensprint.renderCanNotReopenSprintDialog({ model: model }));
    }

    GH.Dialog.addCancelButton(dialog);

    AJS.$('.aui-dialog').addClass('ghx-dialog');

    dialog.show();
    AJS.$('.aui-blanket').empty();

    AJS.$("#ghx-release-name").focus();
};

/**
 * Complete sprint
 * @param {ReopenSprintViewModel} model
 */
GH.Dialogs.ReopenSprintDialog.complete = function (dialog, model) {
    GH.Ajax.put({
        url: '/sprint/' + model.sprint.id + '/reopen',
        data: {
            rapidViewId: model.rapidViewId,
            sprintId: model.sprint.id
        },
        errorContextMap: {
            name: '#ghx-release-name',
            releaseDate: '#ghx-release-date'
        }
    }).done(function (result) {

        GH.Dialogs.ReopenSprintDialog.analyticsMetaData({
            sprintId: model.sprint.id,
            issuesMovedBack: model.issuesMovedBack,
            completedIssuesNotMovedBack: model.completedIssuesNotMovedBack,
            incompleteIssuesNotMovedBack: model.incompleteIssuesNotMovedBack
        }); // SAFE

        // no errors! first, remove dialog...
        dialog.dispose();

        // .. then show success message
        GH.Notification.showSuccess(result.success.message);

        // fire an event
        AJS.$(GH).trigger(GH.Dialogs.ReopenSprintDialog.EVENT_SPRINT_REOPENED, model.sprint.id);
    }).fail(function () {
        dialog.hideSpinner();
        dialog.enableControls();
    });
};