GH.Dialogs.RemoveStatus = {};

GH.Dialogs.RemoveStatus.EVENT_STATUS_REMOVED = "statusRemoved";

(function() {
    var AnalyticsTracker = require('jira-agile/rapid/analytics-tracker');
    /**
     * @type module:jira-agile/rapid/analytics-tracker
     */
    GH.Dialogs.RemoveStatus.analytics = new AnalyticsTracker('gh.config.remove.status.dialog.change');
})();

GH.Dialogs.RemoveStatus.showDialog = function(rapidViewId, statusId) {
    GH.Dialog.dim();


    GH.Ajax.get({
        url:'/workflow/status/remove.json',
        data : {
            rapidViewId : rapidViewId,
            statusId : statusId
        }
    }, "removeStatusDialog")
        .done(GH.Dialogs.RemoveStatus.renderDialog)
        .fail(GH.Dialog.undim);
    GH.Dialogs.RemoveStatus.analytics.trigger("start"); // SAFE
};

/**
 * Renders the "remove status" dialog
 */
GH.Dialogs.RemoveStatus.renderDialog = function(model) {
    // cancel callback
    var cancelFn = function() {
        GH.Dialogs.RemoveStatus.analytics.trigger("cancel"); // SAFE
    };

    // create the dialog
    var dialog = GH.Dialog.create({
        width : 575,
        height : 250,
        id : 'ghx-dialog-remove-status',
        onCancelFn: cancelFn
    });
    dialog.addHeader(AJS.I18n.getText('gh.rapid.config.workflow.remove.status.dialog.title'));
    dialog.addPanel('', 'panel');

    var statusName = AJS.escapeHTML(String(model.statusName)),
        newInitialStatusTitle = "",
        newInitialStatusDesc = "";
    if (model.isInitialStatus) {
        var newInitialStatusName = AJS.escapeHTML(String(model.newInitialStatusName));
        newInitialStatusTitle = AJS.I18n.getText('gh.rapid.config.workflow.remove.status.dialog.initial.status.title', model.statusName, model.projectName);
        newInitialStatusDesc = AJS.I18n.getText('gh.rapid.config.workflow.remove.status.dialog.initial.status.desc', '<b>', newInitialStatusName, '</b>');
    }

    dialog.getCurrentPanel().html(GH.tpl.dialogs.removestatus.renderRemoveStatusDialog({
        statusName: statusName,
        isInitialStatus: model.isInitialStatus,
        newInitialStatusTitle: newInitialStatusTitle,
        newInitialStatusDesc: newInitialStatusDesc
    }));
    dialog.addButton(AJS.I18n.getText('gh.rapid.config.workflow.remove.status.dialog.submit.label'), function() {
        dialog.disableControls();
        GH.Dialogs.RemoveStatus.submit(dialog, model);
    },'aui-button');
    GH.Dialog.addCancelButton(dialog);

    AJS.$('.aui-dialog').addClass('ghx-dialog');

    dialog.show();
    dialog.updateHeight();
};

/**
 * Submit the dialog
 */
GH.Dialogs.RemoveStatus.submit = function(dialog, model) {
    // create the data we send to the server
    var data = {
        statusId: model.statusId,
        workflowName: model.workflowName,
        isInitialStatus: false
    };
    if (model.isInitialStatus) {
        data['isInitialStatus'] = model.isInitialStatus;
        data['newInitialStatusId'] = model.newInitialStatusId;
    }

    GH.Ajax.post({
        url: '/workflow/status/remove.json',
        data: data
    })
        .done(function(result) {
            // analytics for state change and also meta data
            GH.Dialogs.RemoveStatus.analytics.trigger("complete"); // SAFE

            // close our dialog
            dialog.dispose();

            // tell parties about the success
            AJS.$(GH).trigger(GH.Dialogs.RemoveStatus.EVENT_STATUS_REMOVED, model.statusId);
        })
        .fail(dialog.enableControls);
};
