/**
 * Holds the state for the welcome mat wizard. Also takes care of history-based navigation.
 */
GH.Dialog.CreateView.State = {};

// this is where all data lives
GH.Dialog.CreateView.State.data = {};

/**
 * Sets the target of the preferred tab.
 */
GH.Dialog.CreateView.State.setPreferredTab = function(tabTarget) {
    GH.storage.put('gh.dialog.createView.preferredTab', tabTarget, true);
};

/**
 * Retrieve the preferred tab target.
 */
GH.Dialog.CreateView.State.getPreferredTab = function() {
    return GH.storage.get('gh.dialog.createView.preferredTab', true);
};
