AJS.test.require(['com.pyxis.greenhopper.jira:gh-rapid-tests', 'com.pyxis.greenhopper.jira:gh-rapid-inline-editable-deps'], function() {
    var TimeTrackingFieldsHelper = require('jira-agile/rapid/ui/detail/inlineedit/timetracking-fields-helper');
    var $ = require('jquery');
    var IssueFieldUtil = require('jira/components/issueviewer/legacy/issuefieldutil');

    var Static = TimeTrackingFieldsHelper._visibleForTesting;

    function givenFieldHasValue(fieldId) {
        $('#' + fieldId + ' .ghx-fa').remove();
    }

    module('TimeTrackingFieldsHelper specifyWhichFieldToSave', {
        setup: function() {
            sinon.stub(IssueFieldUtil, 'getFieldSelector', function(id) {
                return '#' + id;
            });
            this.editsInProgress = [];
            this.data = {};
            var $originalField = $('<div id="timeoriginalestimate">' +
                                    '<div class="ghx-fa"></div>' +
                                    '</div>');

            var $remainingField = $('<div id="timeestimate">' +
                                    '<div class="ghx-fa"></div>' +
                                    '</div>');
            $("#qunit-fixture").append($originalField).append($remainingField);
        },

        teardown: function() {
            IssueFieldUtil.getFieldSelector.restore();
        }
    });

    test('When original has a value, only save remaining', function() {
        var fieldToSaveId = Static.REMAINING_TIME_ESTIMATE;

        givenFieldHasValue(Static.ORIGINAL_TIME_ESTIMATE);

        this.data[Static.ORIGINAL_ESTIMATE_FORM_PARAM_ID] = "3w";
        this.data[Static.REMAINING_ESTIMATE_FORM_PARAM_ID] = "5w";

        TimeTrackingFieldsHelper.specifyWhichFieldToSave(fieldToSaveId, this.data, this.editsInProgress);

        equal(this.data[Static.TARGET_FIELD_PARAM_NAME], Static.REMAINING_ESTIMATE_FORM_PARAM_ID);
        equal(this.data[Static.ORIGINAL_ESTIMATE_FORM_PARAM_ID], "3w", "Did not modify value for field not being saved");
    });

    test('When remaining has a value, only save original', function() {
        var fieldToSaveId = Static.ORIGINAL_TIME_ESTIMATE;

        givenFieldHasValue(Static.REMAINING_TIME_ESTIMATE);

        this.data[Static.ORIGINAL_ESTIMATE_FORM_PARAM_ID] = "3w";
        this.data[Static.REMAINING_ESTIMATE_FORM_PARAM_ID] = "5w";

        TimeTrackingFieldsHelper.specifyWhichFieldToSave(fieldToSaveId, this.data, this.editsInProgress);

        equal(this.data[Static.TARGET_FIELD_PARAM_NAME], Static.ORIGINAL_ESTIMATE_FORM_PARAM_ID);
        equal(this.data[Static.REMAINING_ESTIMATE_FORM_PARAM_ID], "5w", "Did not modify value for field not being saved");
    });

    test('When remaining has no value, save both fields with same value', function() {
        var fieldToSaveId = Static.ORIGINAL_TIME_ESTIMATE;

        this.editsInProgress = ['timeoriginalestimate'];

        this.data[Static.ORIGINAL_ESTIMATE_FORM_PARAM_ID] = "3w";
        this.data[Static.REMAINING_ESTIMATE_FORM_PARAM_ID] = "5w";

        TimeTrackingFieldsHelper.specifyWhichFieldToSave(fieldToSaveId, this.data, this.editsInProgress);

        ok(!this.data[Static.TARGET_FIELD_PARAM_NAME], "Should not specify target field to save.");
        ok(!this.data[Static.REMAINING_ESTIMATE_FORM_PARAM_ID], "Should not put value in field to duplicate to.");
        equal(this.data[Static.ORIGINAL_ESTIMATE_FORM_PARAM_ID], "3w", "Should have correct value in form param for field being saved.");
    });

    test('When other tracking field is being edited, save only current field.', function() {
        var fieldToSaveId = Static.ORIGINAL_TIME_ESTIMATE;

        this.editsInProgress = ['timeestimate'];

        this.data[Static.ORIGINAL_ESTIMATE_FORM_PARAM_ID] = "3w";
        this.data[Static.REMAINING_ESTIMATE_FORM_PARAM_ID] = "5w";

        TimeTrackingFieldsHelper.specifyWhichFieldToSave(fieldToSaveId, this.data, this.editsInProgress);

        equal(this.data[Static.TARGET_FIELD_PARAM_NAME], Static.ORIGINAL_ESTIMATE_FORM_PARAM_ID);
        equal(this.data[Static.REMAINING_ESTIMATE_FORM_PARAM_ID], "5w", "Did not modify value for field not being saved");
    });
});