AJS.test.require(['com.pyxis.greenhopper.jira:gh-rapid-tests', 'com.pyxis.greenhopper.jira:gh-rapid-inline-editable-deps'], function() {
    require([
        'jira-agile/rapid/ui/detail/inlineedit/issue-editor-fake-server'
    ], function(
        FakeServer
    ) {

        module('Agile detail view inline editor tests', {
            setup: function() {
                this.context = AJS.test.mockableModuleContext();
                this.editor = this.context.require('jira-agile/rapid/ui/detail/inlineedit/issue-detail-view-inline-editor');
                FakeServer.setup();

                this.editor.init({
                    $detailContainer : AJS.$(),
                    loadIssueDetailCallback : this.editor.loadIssueToEditor, // because the DetailsView.load will call to this method
                    getInlineEditableFieldsCallback: function() {
                        return {
                            issueId: FakeServer.issueId,
                            issueKey: FakeServer.issueKey,
                            fields: []
                        };
                    },
                    getIssueIdCallback : function() {
                        return FakeServer.issueId;
                    },
                    getIssueKeyCallback : function() {
                        return FakeServer.issueKey;
                    }
                });
                sinon.stub(this.editor._issueEditorWrapper.getWrappedIssueEditor(), 'canDismissComment').returns(true);

                // if an async test stuck (waiting for a start()) beyond this number, a timeout error will be raised
                QUnit.config.testTimeout = 5000;
            },

            teardown: function() {
                FakeServer.teardown();
                this.editor.destroy();
                QUnit.config.testTimeout = undefined;
                JIRA.unbind(JIRA.Events.NEW_CONTENT_ADDED);
            }
        });

        test('Test number of NEW_CONTENT_ADDED events fired', function() {
            AJS.$("#qunit-fixture").append('<div id="attachmentmodule"/>');

            // - if this threshold exceeds, there will be an error raised by the expect() method
            // - if less than this threshold, a timeout error will be thrown by qunit
            var numberOfEventExpected = 1;
            expect(numberOfEventExpected); // number of assertions
            stop(numberOfEventExpected);

            JIRA.bind(JIRA.Events.NEW_CONTENT_ADDED, function(e, context) {
                ok(context.is('#attachmentmodule'), 'Expect NEW_CONTENT_ADDED event fired only for initializing the attachment drop zone');
                start();
            });

            this.editor.loadIssueToEditor();
            FakeServer.respond();
        });

    });

});