/* global AJS */
define('jira-agile/rapid/ui/detail/details-view-scroll-tracker/scroller', [
    'jquery'
], function ($) {
    'use strict';

    var DetailsViewScroller = {};

    var $scrollableContainer;
    var beforeScroll;
    var afterScroll;

    /**
     * @param params.beforeScroll callback that is called before the scroll action occurs
     * @param params.afterScroll callback that is called before the scroll action and animation has finished
     */
    DetailsViewScroller.init = function(params) {
        beforeScroll = params.beforeScroll;
        afterScroll = params.afterScroll;

        $scrollableContainer = $('#ghx-detail-nav');
    };

    DetailsViewScroller.scrollToSection = function(sectionId, animate) {
        var $section = $('#' + sectionId);
        return this.scrollTo(this.getScrollPosition() + $section.position().top, animate);
    };

    DetailsViewScroller.scrollTo = function(target, animate) {
        beforeScroll();
        $scrollableContainer.animate({
            scrollTop: target
        }, animate ? 'fast' : 0, function () {
            // need to push that to the next call stack to avoid "collision" with the end of animation
            setTimeout(afterScroll, 0);
        });
        return target;
    };

    DetailsViewScroller.getScrollPosition = function() {
        return $scrollableContainer.scrollTop();
    };

    /**
     * Determines the current section that the details view scroll position sits in.
     */
    DetailsViewScroller.getCurrentSection = function() {
        var $detailsSections = $scrollableContainer.find('.ghx-detail-section').not('.ghx-hidden-tab');

        var currentSection;
        if ($scrollableContainer.length > 0 && $scrollableContainer[0].scrollHeight - this.getScrollPosition() === $scrollableContainer.height()) {
            // the user scrolled the details view to max bottom, the current section is
            currentSection = $detailsSections[$detailsSections.length - 1];
        } else {
            for (var idx = 0; idx < $detailsSections.length; idx++) {
                var $section = $detailsSections.eq(idx);
                if ($section.position().top + $section.height() > 0) {
                    // the section is at the top of the view port
                    currentSection = $section[0];
                    break;
                }
            }
        }
        return currentSection ? currentSection.id : null;
    };

    return DetailsViewScroller;
});

