
AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid"], function() {
    var $ = require('jquery');
    var GlobalEvents = require('jira-agile/rapid/global-events');
    var DetailsViewScrollTracker = require('jira-agile/rapid/ui/detail/details-view-scroll-tracker');
    var DetailsViewScroller = require('jira-agile/rapid/ui/detail/details-view-scroll-tracker/scroller');


    module("loadContent", {
        setup: function() {
            GlobalEvents.trigger('pre-initialization');

            this.$detailsNavContent = $(
                '<div id="js-detail-nav-content">' +
                    '<div id="section0"></div>' +
                    '<div id="section1"></div>' +
                    '<div id="section2"></div>' +
                '</div>'
            );

            this.$detailsNavMenu = $(
                '<div class="ghx-detail-nav-menu">' +
                    '<a href="#section0"></a>' +
                    '<a href="#section1"></a>' +
                    '<a href="#section2"></a>' +
                '</div>'
            );

            $('#qunit-fixture').append(this.$detailsNavContent).append(this.$detailsNavMenu);

            this.section0 = 'section0';
            this.section1 = 'section1';
            this.section2 = 'section2';

            this.storedSection = this.section0;
            var test = this;
            sinon.stub(GH.storage, 'get', function(key) {
                if (key === 'gh.detailTab') {
                    return test.storedSection;
                }
            });

            sinon.stub(GH.storage, 'put', function(key, value) {
                if (key === 'gh.detailTab') {
                    test.storedSection = value;
                }
            });

            DetailsViewScroller.getCurrentSection = sinon.stub().returns(this.section0);
            DetailsViewScroller.getScrollPosition = sinon.stub().returns(0);
            DetailsViewScroller.scrollTo = sinon.spy();
            DetailsViewScroller.scrollToSection = sinon.spy();

            this.onSelectedNavChanged = sinon.spy();

            this.clock = sinon.useFakeTimers();

            this.loadIssue = function (id) {
                DetailsViewScrollTracker.init({
                    onSelectedNavChanged: this.onSelectedNavChanged
                });
                DetailsViewScrollTracker.afterDetailsViewLoaded({
                    issueId: id
                });
            }

            this.clickNavButton = function(sectionId) {
                var event = {
                    preventDefault: sinon.stub()
                };
                var element = {
                    hash: '#' + sectionId
                }
                DetailsViewScrollTracker._testing_only.navMenuClick.call(element, event);
            }
        },
        teardown: function() {
            GH.storage.get.restore();
            GH.storage.put.restore();
            this.clock.restore();
        }
    });

    function resetMethodSpyCount() {
        DetailsViewScroller.scrollTo.reset();
        DetailsViewScroller.scrollToSection.reset();
    }

    test("Issue should reload at exactly the same spot after scrolling", sinon.test(function() {
        this.loadIssue(10000);

        // Scroll
        this.$detailsNavContent.trigger('scroll.scrollTracking');
        DetailsViewScroller.getScrollPosition.returns(100);
        this.clock.tick(50);

        // load issue again
        this.loadIssue(10000);

        // Assert that details view was scrolled to correct location.
        sinon.assert.calledWith(DetailsViewScroller.scrollTo, 100);
    }));


    test("New issue should load at the section, not the exact position.", sinon.test(function() {
        this.loadIssue(10000);

        // Scroll to 100px
        this.$detailsNavContent.trigger('scroll.scrollTracking');
        DetailsViewScroller.getScrollPosition.returns(100);
        this.clock.tick(50);

        resetMethodSpyCount();


        // load different issue
        this.loadIssue(10001);

        sinon.assert.notCalled(DetailsViewScroller.scrollTo);
        sinon.assert.calledWith(DetailsViewScroller.scrollToSection, this.section0);
    }));

    test("Issue should reload at the exact position, after scrolling into a new section", sinon.test(function() {
        this.loadIssue(10000);

        // Scroll into a new section
        this.$detailsNavContent.trigger('scroll.scrollTracking');
        DetailsViewScroller.getScrollPosition.returns(200);
        DetailsViewScroller.getCurrentSection.returns(this.section1);
        this.clock.tick(50);

        equal(this.storedSection, this.section1, "Expected to have stored the new section.");

        // load same issue
        this.loadIssue(10000);

        sinon.assert.calledWith(DetailsViewScroller.scrollTo, 200);
    }));

    test("New issue should load at the top of the section that was scrolled into previously", sinon.test(function() {
        this.loadIssue(10000);

        // Scroll into a new section
        this.$detailsNavContent.trigger('scroll.scrollTracking');
        DetailsViewScroller.getScrollPosition.returns(200);
        DetailsViewScroller.getCurrentSection.returns(this.section1);
        this.clock.tick(50);

        resetMethodSpyCount();

        // load different issue
        this.loadIssue(10001);

        sinon.assert.notCalled(DetailsViewScroller.scrollTo);
        sinon.assert.calledWith(DetailsViewScroller.scrollToSection, this.section1);
    }));

    test("Clicking nav button should scroll to correct section with animation", sinon.test(function() {
        this.loadIssue(10000);

        resetMethodSpyCount();

        this.clickNavButton(this.section2);

        sinon.assert.notCalled(DetailsViewScroller.scrollTo);
        // Check that we scrolled to section with animation: true
        sinon.assert.calledWith(DetailsViewScroller.scrollToSection, this.section2, true);
    }));


    test("Clicking nav button should save the stored section, and loading a new issue should respect that.", sinon.test(function() {
        this.loadIssue(10000);

        this.clickNavButton(this.section2);

        equal(this.storedSection, this.section2, "Expected to have stored the new section.");

        resetMethodSpyCount();

        this.loadIssue(10001);

        equal(this.storedSection, this.section2, "Expected to still have stored the new section.");
        sinon.assert.notCalled(DetailsViewScroller.scrollTo);
        sinon.assert.calledWith(DetailsViewScroller.scrollToSection, this.section2);
    }));

    test("Clicking nav button triggers onSelectedNavChangedCallback", sinon.test(function() {
        this.loadIssue(10000);

        this.onSelectedNavChanged.reset();
        this.clickNavButton(this.section2);
        sinon.assert.calledWith(this.onSelectedNavChanged, this.section2);
    }));

    test("Using setSelectedTab before calling init on the same issue overrides the saved position.", sinon.test(function() {
        this.loadIssue(10000);

        // Scroll to 100px
        this.$detailsNavContent.trigger('scroll.scrollTracking');
        DetailsViewScroller.getScrollPosition.returns(100);
        this.clock.tick(50);

        DetailsViewScrollTracker.setSelectedTab(this.section2);

        equal(this.storedSection, this.section2, "Expected to have stored the new section.");

        resetMethodSpyCount();

        this.loadIssue(10000);

        sinon.assert.notCalled(DetailsViewScroller.scrollTo);
        sinon.assert.calledWith(DetailsViewScroller.scrollToSection, this.section2);
    }));
});