AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid-tests", "com.pyxis.greenhopper.jira:gh-rapid-inline-editable-deps"], function () {
    var $ = require('jquery');

    module("loadContent", {
        setup: function setup() {
            this.successFn = sinon.spy();
            this.savedFieldId = undefined;
            GH.Test.setUpFakeServer(this);

            GH.DetailsView._InlineEditor = {
                getIssueAttachmentQuery: function getIssueAttachmentQuery() {
                    return {};
                }
            };
        },
        teardown: function teardown() {
            GH.Test.restoreServer(this);
            delete GH.DetailsView._InlineEditor;
        }
    });

    test("Successful Ajax request sets the view data", sinon.test(function () {
        this.stub(GH.DetailsObjectFactory.getDetailsModel(), "setViewData");
        this.stub(GH.DetailsView, "showSpinner");
        this.stub(GH.DetailsView, "hideSpinner");

        GH.Test.respondToGetWith200(this, "/xboard/issue/details.json", {});

        GH.DetailsView.loadContent(this.savedFieldId, this.successFn);

        this.server.respond();

        ok(this.successFn.called, "Success function called");
        ok(GH.DetailsObjectFactory.getDetailsModel().setViewData.called, "Called success method");
        ok(GH.DetailsView.showSpinner.called, "Show Spinner Successfully");
        ok(GH.DetailsView.hideSpinner.called, "Hide Spinner Successfully");
    }));

    test("Failed request does not call success method (no specific error handling)", sinon.test(function () {
        this.stub(GH.DetailsObjectFactory.getDetailsModel(), "setViewData");

        GH.Test.respondToGetWith500(this, "/xboard/issue/details.json", {});

        GH.DetailsView.loadContent(this.savedFieldId, this.successFn);

        this.server.respond();

        ok(!this.successFn.called, "Success function called");
        ok(!GH.DetailsObjectFactory.getDetailsModel().setViewData.called, "Does not call process function on failure");
    }));

    test("Refresh due to save field does not show spinner while loading", sinon.test(function () {
        this.stub(GH.DetailsObjectFactory.getDetailsModel(), "setViewData");
        this.stub(GH.DetailsView, "showSpinner");
        this.stub(GH.DetailsView, "hideSpinner");

        this.savedFieldId = 3;

        GH.Test.respondToGetWith200(this, "/xboard/issue/details.json", {});

        GH.DetailsView.loadContent(this.savedFieldId, this.successFn);

        this.server.respond();

        ok(this.successFn.called, "Success function called");
        ok(GH.DetailsObjectFactory.getDetailsModel().setViewData.called, "Called success method");
        ok(!GH.DetailsView.showSpinner.called, "Did not show spinner");
    }));

    var DetailsModel = require('jira-agile/rapid/ui/detail/details-model');
    var DetailsFieldRenderer = require('jira-agile/rapid/ui/detail/details-field-renderer');
    var reloadAllFieldsOfSection = false;

    module("testing that DetailsView.load() correctly replaces fields in the DOM", {
        setup: function setup() {
            GH.Test.setUpFakeServer(this);
            GH.Test.respondToGetWith200(this, "/xboard/issue/details.json", { key: 'ISSUE-1' });

            // Want to watch whether the details view spins.
            sinon.spy(GH.DetailsView, "showSpinner");
            sinon.spy(GH.DetailsView, "hideSpinner");

            // Not testing these
            sinon.stub(DetailsModel, 'escapeCommentsRestriction');
            sinon.stub(DetailsModel, 'filterIssueOperations');
            sinon.stub(DetailsFieldRenderer, 'renderFields');

            GH.DetailsView.setContainerSelector("#container");

            GH.DetailsView._InlineEditor = {
                getFieldSelector: function getFieldSelector(fieldId) {
                    return '#' + fieldId + '-val';
                },
                triggerFieldUpdate: sinon.spy(),
                getIssueAttachmentQuery: function getIssueAttachmentQuery() {
                    return {};
                }
            };

            GH.DetailsView._Reloader = {
                reload: function reload(reloadReason, savedFieldId, callback) {
                    if (_.isFunction(callback)) {
                        callback(savedFieldId);
                    } else {
                        reloadAllFieldsOfSection = true;
                    }
                }
            };

            this.savedFieldId = 3;

            // this will be the old field values that will be placed on the DOM.
            var staleDetailsViewHtml = '<div id="container">' + '<div class="ghx-detail-issue">' + '<li id="3-li"><div id="3-val">oldvalue</div></li>' + '<li id="4-li"><div id="4-val">oldvalue</div></li>' + '</div>' + '</div>';
            $('#qunit-fixture').append(staleDetailsViewHtml);

            // Stub out the to be rendered template with the newly rendered field values.
            var newDetailsViewHtml = '<div id="container">' + '<div class="ghx-detail-issue">' + '<li id="3-li"><div id="3-val">newvalue</div></li>' + '<li id="4-li"><div id="4-val">newvalue</div></li>' + '</div>' + '</div>';

            GH.tpl.inlineEditableDetailview.renderIssueDetails = sinon.stub().returns(newDetailsViewHtml);

            sinon.stub(GH.DetailsView, 'hasEditsInProgress').returns(false);
            GH.DetailsView.selectedIssueKey = 'ISSUE-1';
        },
        teardown: function teardown() {
            GH.Test.restoreServer(this);
            GH.DetailsView.hasEditsInProgress.restore();
            GH.DetailsView.showSpinner.restore();
            GH.DetailsView.hideSpinner.restore();
            DetailsModel.escapeCommentsRestriction.restore();
            DetailsModel.filterIssueOperations.restore();
            DetailsFieldRenderer.renderFields.restore();
            delete GH.tpl.inlineEditableDetailview.renderIssueDetails;
            delete GH.DetailsView._InlineEditor;
            delete GH.DetailsView._Reloader;
            reloadAllFieldsOfSection = false;
            delete GH.DetailsView.selectedIssueKey;
        }
    });

    test("Test that saving a field only modifies the saved field on the DOM if edits are in progress.", sinon.test(function () {
        GH.DetailsView.hasEditsInProgress.returns(true);

        GH.DetailsView.load(this.savedFieldId, "some-reason");

        this.server.respond();

        ok(GH.DetailsView.showSpinner.notCalled, "Spinner should not show when refreshing due to a saved field.");

        ok(!reloadAllFieldsOfSection, "Only saved field should have been updated on the dom");

        equal($('#3-val').text(), "newvalue", "Saved field should have been updated on the dom");
        equal($('#4-val').text(), "oldvalue", "Other field should not have been updated on the dom");
    }));

    test("Test that saving a field refreshes all fields if no edits are in progress.", sinon.test(function () {
        GH.DetailsView.hasEditsInProgress.returns(false);

        GH.DetailsView.load(this.savedFieldId, 'some-reason');

        this.server.respond();

        ok(GH.DetailsView.showSpinner.notCalled, "Spinner should not show when refreshing due to a saved field.");

        ok(reloadAllFieldsOfSection, "All fields should have been updated on the dom");
    }));

    test("Test that refreshing without saving a field refreshes whole view and spins.", sinon.test(function () {
        GH.DetailsView.hasEditsInProgress.returns(false);
        this.stub(GH.DetailsObjectFactory.getDetailsModel(), "setViewData");
        this.stub(GH.DetailsView, 'renderDetails');

        GH.DetailsView.load();

        this.server.respond();

        ok(GH.DetailsView.showSpinner.called, "Spinner should show.");
        ok(GH.DetailsView.hideSpinner.called, "Should have called hide spinner");
        ok(GH.DetailsView.renderDetails.called, "Details view should have been reloaded as a whole if there is no reload reason specified");
    }));

    test("Test that refreshing without saving a field refreshes whole view and spins.", sinon.test(function () {
        GH.DetailsView.hasEditsInProgress.returns(false);

        // New rendered view without field 4
        var newDetailsViewHtml = '<div id="container">' + '<div class="ghx-detail-issue">' + '<li id="3-li"><div id="3-val">newvalue</div></li>' + '</div>' + '</div>';
        GH.tpl.inlineEditableDetailview.renderIssueDetails.returns(newDetailsViewHtml);

        GH.DetailsView.load(this.savedFieldId, "reload-reason");

        this.server.respond();

        ok(GH.DetailsView.showSpinner.notCalled, "Spinner should not show.");
        ok(reloadAllFieldsOfSection, "All fields should have been reloaded.");
    }));

    module("Width calculation for resizing detail view");

    test("correctly turns stored width % into pixels", function () {
        QUnit.GhFixtures.addFixture("<div id='ghx-backlog' style='width:500px'></div>");
        QUnit.GhFixtures.addFixture("<div id='ghx-detail-view' style='width:400px'></div>");

        sinon.stub(GH.RapidBoard.State, "getDetailViewWidth").returns(0.5);

        // expect 50% of total which is 900
        ok(GH.DetailsView.getWidth() <= 450);

        GH.RapidBoard.State.getDetailViewWidth.restore();
    });

    test("returns min width if stored % is too small", function () {
        QUnit.GhFixtures.addFixture("<div id='ghx-backlog' style='width:200px'></div>");
        QUnit.GhFixtures.addFixture("<div id='ghx-detail-view' style='width:400px'></div>");

        sinon.stub(GH.RapidBoard.State, "getDetailViewWidth").returns(0.5);

        // total is 600, stored is 50% which would be too small
        equal(GH.DetailsView.getWidth(), 400);

        GH.RapidBoard.State.getDetailViewWidth.restore();
    });

    test("does not allow greater than 50% of width", function () {
        QUnit.GhFixtures.addFixture("<div id='ghx-backlog' style='width:500px'></div>");
        QUnit.GhFixtures.addFixture("<div id='ghx-detail-view' style='width:400px'></div>");

        sinon.stub(GH.RapidBoard.State, "getDetailViewWidth").returns(0.8);

        // total is 600, stored is 80% which would be too big
        // should not happen in reality
        ok(GH.DetailsView.getWidth() <= 450);

        GH.RapidBoard.State.getDetailViewWidth.restore();
    });

    module("hasEditsInProgress tests", {
        setup: function setup() {
            GH.DetailsView._InlineEditor = require('jira-agile/rapid/ui/detail/inlineedit/issue-detail-view-inline-editor');
            sinon.stub(GH.DetailsView._InlineEditor, 'getEditsInProgress').returns([]);
        },
        teardown: function teardown() {
            GH.DetailsView._InlineEditor.getEditsInProgress.restore();
        }
    });

    test("test when platform editor has edits", function () {
        GH.DetailsView._InlineEditor.getEditsInProgress.returns(['foo']);

        var editsInProgress = GH.DetailsView.hasEditsInProgress();
        ok(editsInProgress, "Expected to have edits in progress");
    });

    test("test has no edits", function () {
        var editsInProgress = GH.DetailsView.hasEditsInProgress();
        ok(!editsInProgress, "Expected not to have edits in progress");
    });
});