AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid-tests"], function () {
    module('GH.DetailsModel', {
        setup: function setup() {},
        teardown: function teardown() {}
    });

    function testProcessFields(viewData, expectedFieldSections) {
        GH.DetailsObjectFactory.getDetailsModel().processFields(viewData);
        deepEqual(GH.DetailsObjectFactory.getDetailsModel().fieldSections, expectedFieldSections);
    }

    function createField(id) {
        return { id: id };
    }

    function createHeaderTab(params) {
        return {
            primaryStatisticFieldId: params.primaryStatisticFieldId,
            trackingStatisticFieldId: params.trackingStatisticFieldId,
            tabs: {
                defaultTabs: [{
                    tabId: 'HEADER',
                    fields: params.fields
                }]
            }
        };
    }

    test('processFields of Header tab for inline-editable models', function () {
        testProcessFields(createHeaderTab({ fields: [] }), {
            dates: [],
            description: [],
            details: [],
            estimate: [],
            header: [],
            links: [],
            people: []
        });
        testProcessFields(createHeaderTab({ fields: [createField('description'), createField('assignee'), createField('customfield_123'), createField('unknownfield')] }), {
            dates: [],
            description: ['description'],
            details: ['customfield_123', 'unknownfield'],
            estimate: [],
            header: [],
            links: [],
            people: ['assignee']
        });
        testProcessFields(createHeaderTab({ primaryStatisticFieldId: 'customfield_123', fields: [createField('description'), createField('assignee'), createField('customfield_123'), createField('unknownfield')] }), {
            dates: [],
            description: ['description'],
            details: ['unknownfield'],
            estimate: ['customfield_123'],
            header: [],
            links: [],
            people: ['assignee']
        });

        testProcessFields(createHeaderTab({ primaryStatisticFieldId: 'customfield_123', trackingStatisticFieldId: 'remainingtime', fields: [createField('description'), createField('assignee'), createField('customfield_123'), createField('unknownfield'), createField('remainingtime')] }), {
            dates: [],
            description: ['description'],
            details: ['unknownfield'],
            estimate: ['customfield_123'],
            header: [],
            links: [],
            people: ['assignee']
        });
    });

    module('GH.DetailsModel.renameWatchIssueId', {
        setup: function setup() {
            this.DetailsModel = GH.DetailsObjectFactory.getDetailsModel();

            this.otherOperation = {
                id: "not-toggle-watch-issue",
                name: "Something Else"
            };
            this.watchIssueOperation = {
                id: "toggle-watch-issue",
                name: "Watch Issue"
            };
            this.operations = [this.otherOperation, this.watchIssueOperation];
        },
        teardown: function teardown() {}
    });

    test('Test renaming of watch issue', function () {
        this.DetailsModel.renameWatchIssueId(this.operations);
        deepEqual(this.operations[0], this.otherOperation);
        ok(this.operations[1].id === "gh-toggle-watch-issue");
    });
});