AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid-tests", "com.pyxis.greenhopper.jira:gh-rapid-inline-editable-deps"], function() {
    const DetailsFieldUtils = require('jira-agile/rapid/ui/detail/editable/details-field-utils');
    const $ = require('jquery');

    module("utils test", {
        setup: function() {
            this.subtasksTab = {
                tabId: 'SUBTASKS',
                sections: [
                    {
                        id: 'subtasks-updated',
                    },
                ],
            };
            this.thirdPartyTab_1 = {
                tabId: 'THIRD_PARTY',
                sections: [
                    {
                        id: 'section-3',
                    },
                    {
                        id: 'section-4',
                    },
                    {
                        id: 'section-5',
                    },
                ],
            };
            this.thirdPartyTab_2 = {
                tabId: 'THIRD_PARTY',
                sections: [
                    {
                        id: 'section-7',
                    },
                ],
            };

            const staleDetailsNavHtml =
                `<div class="container">
                    <ul>
                        <li id="SUBTASKS-nav" class="ghx-detail-nav-item">
                            <a href="subtasks">subtasks</a>
                        </li>
                        <li id="THIRD_PARTY-nav" class="ghx-detail-nav-item">
                            <a href="section-1">section-1</a>
                        </li>
                        <li id="THIRD_PARTY-nav" class="ghx-detail-nav-item">
                            <a href="section-2">section-2</a>
                        </li>
                    </ul>
                </div>`;

            $('#qunit-fixture').append(staleDetailsNavHtml);

            GH.tpl.inlineEditableDetailview.renderTabNavigation = function(props) {
                const {tab} = props;
                let resp = '';
                tab.sections.forEach(function (section) {
                    resp += `<li id="${tab.tabId}-nav" class="ghx-detail-nav-item"><a href="${section.id}">${section.id}</a></li>`;
                });
                return resp;
            };
        },
        teardown: function() {
            delete GH.tpl.inlineEditableDetailview.renderIssueDetails;
        }
    });

    test("Number of sections in navigation is right while replacing them", function() {
        equal($('.container').find('.ghx-detail-nav-item').length, 3, 'initial number of items in navbar is wrong');

        DetailsFieldUtils.replaceTabNavigation(this.subtasksTab, $('.container'));
        equal($('.container').find('.ghx-detail-nav-item').first().text(), 'subtasks-updated', 'replacement is done');
        equal($('.container').find('.ghx-detail-nav-item').length, 3, 'after simple replacement number of items in navbar is correct');

        DetailsFieldUtils.replaceTabNavigation(this.thirdPartyTab_1, $('.container'));
        equal($('.container').find('.ghx-detail-nav-item').length, 4, 'after replacement with more elements number of items in navbar is correct');

        DetailsFieldUtils.replaceTabNavigation(this.thirdPartyTab_2, $('.container'));
        equal($('.container').find('.ghx-detail-nav-item').length, 2, 'after replacement with less elements number of items in navbar is correct');
    });
});