GH.PagesSearchModel = {};

GH.PagesSearchModel.model = {};

GH.PagesSearchModel.set = function (entityId, pages) {
    GH.PagesSearchModel.model[entityId] = pages;
};

GH.PagesSearchModel.list = function (entityId) {
    return GH.PagesSearchModel.model[entityId];
};

GH.PagesSearchModel.get = function (entityId, pageId) {
    pageId = parseInt(pageId, 10);
    return _.find(GH.PagesSearchModel.model[entityId], function (page) {
        return page.id === pageId;
    });
};

GH.PagesSearchModel.removePage = function (entityId, pageId) {
    pageId = parseInt(pageId, 10);
    GH.PagesSearchModel.model[entityId] = _.reject(GH.PagesSearchModel.model[entityId], function (page) {
        return page.id === pageId;
    });
};

GH.PagesSearchModel.clear = function (entityId) {
    delete GH.PagesSearchModel.model[entityId];
};