define('jira-agile/rapid/ui/component/extra-fields/ExtraFieldsHelper', ['require'], function (require) {
    'use strict';

    var _ = require('underscore');

    var renderers = {
        epiclink: function epiclink(extraField) {
            return GH.EpicConfig.getEpicNameString(extraField.text, extraField.epicKey);
        },
        html: function html(extraField) {
            if (extraField.html && extraField.html !== '&nbsp;') {
                // The ordainedSanitizedHTML method will not work here as the
                // version of soyutils provided by gadgets does not support it.
                // so instead this will be used to decide if the soy template should noAutoescape the content.
                extraField.useSoyNoAutoescape = true;
                return extraField.html;
            } else {
                return '';
            }
        }
    };

    var defaultRenderer = function defaultRenderer(extraField) {
        return extraField.html || extraField.text;
    };

    var ExtraFieldsHelper = {
        /**
         * Adds a `renderedContent` value on each of the extra fields based on the field's renderer.
         *
         * @param {Object[]} extraFields
         */
        prepareExtraFields: function prepareExtraFields(extraFields) {
            _.each(extraFields, function (extraField) {
                var renderer = renderers[extraField.renderer] || defaultRenderer;
                extraField.renderedContent = renderer(extraField);
            });
        }
    };

    return ExtraFieldsHelper;
});

AJS.namespace('GH.ExtraFieldsHelper', null, require('jira-agile/rapid/ui/component/extra-fields/ExtraFieldsHelper'));