define('jira-agile/rapid/ui/chart/v2/releaseburndown/release-burndown-chart-table-data-service', ['require'], function(require) {
    'use strict';

    // REQUIRES
    var _ = require('underscore');
    var GlobalEvents = require('jira-agile/rapid/global-events');
    var RapidBoardDataLoader = require('jira-agile/rapid/rapid-board-data-loader');

    var Ajax;
    var ScopeBurndownBySprintTransformer;

    GlobalEvents.on('pre-initialization', function() {
        Ajax = GH.Ajax;
        ScopeBurndownBySprintTransformer = GH.Reports.ScopeBurndownBySprintTransformer;
    });

    /**
     * Sends request to retrieve issue data for table
     *
     * @param {Object} requestParams
     * @returns {Promise}
     */
    function fetchData(requestParams) {
        var opts = {
            url: '/rapid/charts/versionreport',
            data: requestParams
        };
        return Ajax.get(opts, 'versionReportData');
    }

    function transformData (issueData, sprintData) {
        issueData.showIssueEpic = true;

        [
            issueData.contents.completedIssues,
            issueData.contents.incompleteEstimatedIssues,
            issueData.contents.incompleteUnestimatedIssues
        ].forEach(issues => RapidBoardDataLoader.resolveEntities(issues, issueData.contents.entityData));

        return ScopeBurndownBySprintTransformer.getIssuesBySprintData(issueData, sprintData);
    }

    function ReleaseBurndownChartTableDataService() {}

    ReleaseBurndownChartTableDataService.prototype = {
        /**
         * Get all issues associated with version on current board. Used to display table beneath Release Burndown chart.
         *
         * @param {number} rapidViewId
         * @param {number} versionId
         * @param {Object} sprintData
         * @returns {Promise}
         */
        get: function(rapidViewId, versionId, sprintData) {
            return this._getData(rapidViewId, versionId).andThen(function(data) {
                data.rapidViewId = rapidViewId;
                return transformData(data, sprintData);
            });
        },

        /**
         * Clear cached data
         */
        clearCache: function() {
            if (this._dataPromise) {
                this._dataPromise = null;
                this._dataRequestParams = null;
            }
        },

        /**
         * For testing
         *
         * @private
         */
        _transformData: transformData,

        /**
         * Gets raw issues data for given rapidViewId, versionId.
         *
         * @param {number} rapidViewId
         * @param {number} versionId
         * @returns {Promise}
         * @private
         */
        _getData: function(rapidViewId, versionId) {
            var requestParams = {
                rapidViewId: rapidViewId,
                versionId: versionId
            };

            // Only send a request if previous one cannot be used
            if (!this._dataPromise || this._dataPromise.state() === 'rejected' || !_.isEqual(this._dataRequestParams, requestParams)) {
                this._dataRequestParams = requestParams;
                this._dataPromise = fetchData(requestParams);
            }
            return this._dataPromise;
        }
    };

    return ReleaseBurndownChartTableDataService;
});