define('jira-agile/rapid/ui/chart/v2/epicburndown/epic-burndown-chart-table-data-service', ['require'], function(require) {
    'use strict';

    // REQUIRES
    var _ = require('underscore');
    var GlobalEvents = require('jira-agile/rapid/global-events');
    var RapidBoardDataLoader = require('jira-agile/rapid/rapid-board-data-loader');

    var Ajax;
    var ScopeBurndownBySprintTransformer;

    GlobalEvents.on('pre-initialization', function() {
        Ajax = GH.Ajax;
        ScopeBurndownBySprintTransformer = GH.Reports.ScopeBurndownBySprintTransformer;
    });

    /**
     * Sends request to retrieve issue data for table
     *
     * @param {Object} requestParams
     * @returns {Promise}
     */
    function fetchData(requestParams) {
        var opts = {
            url: '/rapid/charts/epicreport',
            data: requestParams
        };
        return Ajax.get(opts, 'epicBurndownData');
    }

    function transformData (issueData, sprintData) {
        issueData.showIssueEpic = false;

        [
            issueData.contents.completedIssues,
            issueData.contents.incompleteEstimatedIssues,
            issueData.contents.incompleteUnestimatedIssues
        ].forEach(issues => RapidBoardDataLoader.resolveEntities(issues, issueData.contents.entityData));

        return ScopeBurndownBySprintTransformer.getIssuesBySprintData(issueData, sprintData);
    }

    function EpicBurndownChartTableDataService() {}

    EpicBurndownChartTableDataService.prototype = {
        /**
         * Get all issues associated with epic on current board. Used to display table beneath ScopeBurndown chart.
         *
         * @param {number} rapidViewId
         * @param {string} epicKey
         * @param {Object} sprintData
         * @returns {Promise}
         */
        get: function(rapidViewId, epicKey, sprintData) {
            return this._getData(rapidViewId, epicKey).andThen(function(data) {
                data.rapidViewId = rapidViewId;
                return transformData(data, sprintData);
            });
        },

        /**
         * Clear cached data
         */
        clearCache: function() {
            if (this._dataPromise) {
                this._dataPromise = null;
                this._dataRequestParams = null;
            }
        },

        /**
         * For testing
         *
         * @private
         */
        _transformData: transformData,

        /**
         * Gets raw issues data for given rapidViewId, EpicKey.
         *
         * @param {number} rapidViewId
         * @param {string} epicKey
         * @returns {Promise}
         * @private
         */
        _getData: function(rapidViewId, epicKey) {
            var requestParams = {
                rapidViewId: rapidViewId,
                epicKey: epicKey
            };

            // Only send a request if previous one cannot be used
            if (!this._dataPromise || this._dataPromise.state() === 'rejected' || !_.isEqual(this._dataRequestParams, requestParams)) {
                this._dataRequestParams = requestParams;
                this._dataPromise = fetchData(requestParams);
            }
            return this._dataPromise;
        }
    };

    return EpicBurndownChartTableDataService;
});