/* global GH */
define('jira-agile/rapid/ui/chart/v2/controlchart/control-chart-viewing-options-controller', ['require'], function(require) {
    'use strict';

    var view = GH.Reports.ControlChartViewingOptionsView;

    var ControlChartController;
    var GlobalEvents = require('jira-agile/rapid/global-events');
    GlobalEvents.on('pre-initialization', function () {
        ControlChartController = require('jira-agile/rapid/ui/chart/v2/controlchart/control-chart-controller');
    });

    var handlers = {

        /**
         * Inform parent controller that the model has changed
         */
        modelChanged: function () {
            ControlChartController.update();
        },

        /**
         * Override selected options with the defaults for the current board
         */
        resetToDefaults: function () {
            view.getModel().resetToDefaults();
            view.digest();
        }
    };

    /**
     * Sets up handlers for view to delegate to
     */
    function bindViewHandlers() {
        view.setHandler(function (command) {
            handlers[command]();
        });
    }

    return {
        /**
         * @lends GH.Reports.ControlChartViewingOptionsController
         */
        start: function (settings) {
            bindViewHandlers();
            view.start(settings);
            view.digest();
        }
    };
});
