AJS.test.require("com.pyxis.greenhopper.jira:gh-rapid",function(){module("BurnupTransformer tests",{setup:function(){this.service=GH.Reports.SprintBurnupTransformer},emptyClosedSprint:function(){return{changes:{},startTime:1e3,endTime:1e4,completeTime:1e4,sprintCompleted:!0,now:2e4,statisticField:{typeId:"field",fieldId:"customfield_10002",id:"field_customfield_10002",name:"Story Points",isValid:!0,isEnabled:!0,renderer:"number"},issueToParentKeys:{},workRateData:{timezone:"Australia/Sydney",rates:[{start:0,end:1e4,rate:1}]},openCloseChanges:{1e4:[{userDisplayNameHtml:"<a class='user-hover' rel='admin' id='_admin' href='/jira/secure/ViewProfile.jspa?name=admin'>admin</a>",operation:"CLOSE"}]},lastUserWhoClosedHtml:"<a class='user-hover' rel='admin' id='_admin' href='/jira/secure/ViewProfile.jspa?name=admin'>admin</a>",rapidViewId:0,issueToSummary:[]}},addToSprint:function(e){return{key:e,added:!0}},removeFromSprint:function(e){return{key:e,added:!1}},moveToDone:function(e){return{key:e,column:{notDone:!1}}},moveToNotDone:function(e){return{key:e,column:{notDone:!0}}},changeEstimate:function(e,t){return{key:e,statC:{newValue:t}}},addAndEstimate:function(e,t){return[_.extend(this.moveToNotDone(e),this.changeEstimate(e,t),this.addToSprint(e))]},addWithoutEstimate:function(e){return[_.extend(this.moveToNotDone(e),this.addToSprint(e))]}}),test("Empty sprint",function(){var t=this.emptyClosedSprint(),i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i,{now:t.now,start:t.startTime,startKeys:[],end:t.endTime,sprintCompleted:!0,endKeys:[],nonWorkPeriods:[],scope:[{timestamp:t.startTime,value:0,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"start event"}},{timestamp:t.endTime,value:0,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"end event"}}],work:[{timestamp:t.startTime,value:0,change:{fromValue:void 0,key:void 0,line:"done",toValue:void 0,type:"start event"}},{timestamp:t.endTime,value:0,change:{fromValue:void 0,key:void 0,line:"done",toValue:void 0,type:"end event"}}],statisticField:t.statisticField,rapidViewId:t.rapidViewId,estimatedIssueEvents:0,issueToSummary:[]})}),test("Changes sorted by timestamp",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.changes={1300:this.addAndEstimate("KEY-3",20),1200:this.addAndEstimate("KEY-2",20),1100:this.addAndEstimate("KEY-1",20)};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.scope,[{timestamp:t.startTime,value:0,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"start event"}},{timestamp:1100,value:20,change:{fromValue:0,key:"KEY-1",line:"scope",toValue:20,type:"issue added"}},{timestamp:1200,value:40,change:{fromValue:0,key:"KEY-2",line:"scope",toValue:20,type:"issue added"}},{timestamp:1300,value:60,change:{fromValue:0,key:"KEY-3",line:"scope",toValue:20,type:"issue added"}},{timestamp:t.endTime,value:60,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"end event"}}])}),test("Some events with estimates",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.changes={1100:this.addAndEstimate("KEY-2",20),1200:this.addAndEstimate("KEY-3",20)};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));equal(i.estimatedIssueEvents,3)}),test("Some events without estimates",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.changes={1100:this.addWithoutEstimate("KEY-2"),1200:this.addWithoutEstimate("KEY-3")};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));equal(i.estimatedIssueEvents,0)}),test("End dates",function(){var t=this.emptyClosedSprint();t.startTime=0,t.now=1e3,t.completeTime=void 0,t.endTime=5e3;var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));equal(t.endTime,i.end),equal(t.now,i.now),t.completeTime=1e4,t.endTime=5e3,i=e(this.service.getBurnupModelFromScopeBurndownModel(t)),equal(t.completeTime,i.end),t.completeTime=500,t.endTime=5e3,i=e(this.service.getBurnupModelFromScopeBurndownModel(t)),equal(t.completeTime,i.end),t.startTime=0,t.now=1e3,t.completeTime=void 0,t.endTime=5e3,i=e(this.service.getBurnupModelFromScopeBurndownModel(t)),equal(t.now,i.now),t.startTime=0,t.now=5e3,t.completeTime=void 0,t.endTime=5e3,i=e(this.service.getBurnupModelFromScopeBurndownModel(t)),equal(t.now,i.now)}),test("issues with estimates added before sprint",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.changes={400:this.addWithoutEstimate("KEY-0"),500:this.addAndEstimate("KEY-1",10),700:this.addAndEstimate("KEY-2",20)};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.scope,[{timestamp:t.startTime,value:30,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"start event"}},{timestamp:t.endTime,value:30,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"end event"}}])}),test("issue with estimate added after start",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.changes={500:this.addAndEstimate("KEY-1",10),1700:this.addAndEstimate("KEY-2",20)};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.scope,[{timestamp:t.startTime,value:10,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"start event"}},{timestamp:1700,value:30,change:{fromValue:0,key:"KEY-2",line:"scope",toValue:20,type:"issue added"}},{timestamp:t.endTime,value:30,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"end event"}}])}),test("issue without estimate added after start",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.changes={500:this.addAndEstimate("KEY-1",10),1700:this.addWithoutEstimate("KEY-2")};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.scope,[{timestamp:t.startTime,value:10,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"start event"}},{timestamp:1700,value:10,change:{fromValue:0,key:"KEY-2",line:"scope",toValue:0,type:"issue added"}},{timestamp:t.endTime,value:10,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"end event"}}])}),test("issue estimate updated before sprint",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.changes={500:this.addWithoutEstimate("KEY-1"),700:[this.changeEstimate("KEY-1",5)],900:[this.changeEstimate("KEY-1",15)]};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.scope,[{timestamp:t.startTime,value:15,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"start event"}},{timestamp:t.endTime,value:15,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"end event"}}])}),test("issue estimate updated in sprint",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.changes={500:this.addWithoutEstimate("KEY-1"),1700:[this.changeEstimate("KEY-1",5)],3400:[this.changeEstimate("KEY-1",15)]};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.scope,[{timestamp:t.startTime,value:0,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"start event"}},{timestamp:1700,value:5,change:{fromValue:0,key:"KEY-1",line:"scope",toValue:5,type:"estimate update"}},{timestamp:3400,value:15,change:{fromValue:5,key:"KEY-1",line:"scope",toValue:15,type:"estimate update"}},{timestamp:t.endTime,value:15,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"end event"}}])}),test("issue estimate updated after sprint",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.endTime=1e4,t.changes={500:this.addWithoutEstimate("KEY-1"),1700:[this.changeEstimate("KEY-1",5)],3400:[this.changeEstimate("KEY-1",15)],13400:[this.changeEstimate("KEY-1",0)]};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.scope,[{timestamp:t.startTime,value:0,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"start event"}},{timestamp:1700,value:5,change:{fromValue:0,key:"KEY-1",line:"scope",toValue:5,type:"estimate update"}},{timestamp:3400,value:15,change:{fromValue:5,key:"KEY-1",line:"scope",toValue:15,type:"estimate update"}},{timestamp:t.endTime,value:15,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"end event"}}])}),test("issue with estimate removed from sprint",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.changes={500:this.addAndEstimate("KEY-1",9),1700:[this.removeFromSprint("KEY-1")]};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.scope,[{timestamp:t.startTime,value:9,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"start event"}},{timestamp:1700,value:0,change:{fromValue:9,key:"KEY-1",line:"scope",toValue:0,type:"issue removed"}},{timestamp:t.endTime,value:0,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"end event"}}])}),test("issue without estimate removed from sprint",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.changes={500:this.addAndEstimate("KEY-1",9),600:this.addWithoutEstimate("KEY-2"),1700:[this.removeFromSprint("KEY-2")]};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.scope,[{timestamp:t.startTime,value:9,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"start event"}},{timestamp:1700,value:9,change:{fromValue:0,key:"KEY-2",line:"scope",toValue:0,type:"issue removed"}},{timestamp:t.endTime,value:9,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"end event"}}])}),test("issue not in sprint removed from sprint",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.changes={500:this.addAndEstimate("KEY-1",9),1700:[this.removeFromSprint("NEW-1")]};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.scope,[{timestamp:t.startTime,value:9,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"start event"}},{timestamp:t.endTime,value:9,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"end event"}}])}),test("issue removed then estimate updated",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.changes={500:this.addAndEstimate("KEY-1",9),600:this.addAndEstimate("KEY-2",9),1700:[this.removeFromSprint("KEY-1")],1800:[this.changeEstimate("KEY-1",20)],1900:[this.addToSprint("KEY-1")]};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.scope,[{timestamp:t.startTime,value:18,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"start event"}},{timestamp:1700,value:9,change:{fromValue:9,key:"KEY-1",line:"scope",toValue:0,type:"issue removed"}},{timestamp:1900,value:29,change:{fromValue:0,key:"KEY-1",line:"scope",toValue:20,type:"issue added"}},{timestamp:t.endTime,value:29,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"end event"}}])}),test("issue removed, then added then estimate updated",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.changes={500:this.addAndEstimate("KEY-1",9),600:this.addAndEstimate("KEY-2",9),1700:[this.removeFromSprint("KEY-1")],1800:[this.addToSprint("KEY-1")],1900:[this.changeEstimate("KEY-1",20)]};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.scope,[{timestamp:t.startTime,value:18,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"start event"}},{timestamp:1700,value:9,change:{fromValue:9,key:"KEY-1",line:"scope",toValue:0,type:"issue removed"}},{timestamp:1800,value:18,change:{fromValue:0,key:"KEY-1",line:"scope",toValue:9,type:"issue added"}},{timestamp:1900,value:29,change:{fromValue:9,key:"KEY-1",line:"scope",toValue:20,type:"estimate update"}},{timestamp:t.endTime,value:29,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"end event"}}])}),test("negative estimate",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.changes={500:this.addAndEstimate("KEY-1",-1)};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.scope,[{timestamp:t.startTime,value:0,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"start event"}},{timestamp:t.endTime,value:0,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"end event"}}])}),test("work completed during sprint",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.changes={500:this.addAndEstimate("KEY-1",9),600:this.addAndEstimate("KEY-2",9),1700:[this.moveToDone("KEY-1")]};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.work,[{timestamp:t.startTime,value:0,change:{fromValue:void 0,key:void 0,line:"done",toValue:void 0,type:"start event"}},{timestamp:1700,value:9,change:{fromValue:0,key:"KEY-1",line:"done",toValue:9,type:"issue done"}},{timestamp:t.endTime,value:9,change:{fromValue:void 0,key:void 0,line:"done",toValue:void 0,type:"end event"}}])}),test("work completed before sprint",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.changes={500:this.addAndEstimate("KEY-1",9),600:[this.moveToDone("KEY-1")],800:this.addAndEstimate("KEY-2",9),1600:[this.moveToDone("KEY-2")]};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.work,[{timestamp:t.startTime,value:0,change:{fromValue:void 0,key:void 0,line:"done",toValue:void 0,type:"start event"}},{timestamp:1600,value:9,change:{fromValue:0,key:"KEY-2",line:"done",toValue:9,type:"issue done"}},{timestamp:t.endTime,value:9,change:{fromValue:void 0,key:void 0,line:"done",toValue:void 0,type:"end event"}}]),deepEqual(i.scope,[{timestamp:t.startTime,value:9,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"start event"}},{timestamp:t.endTime,value:9,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"end event"}}])}),test("work completed then uncompleted before sprint",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.changes={500:this.addAndEstimate("KEY-1",9),600:[this.moveToDone("KEY-1")],700:[this.moveToNotDone("KEY-1")]};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.work,[{timestamp:t.startTime,value:0,change:{fromValue:void 0,key:void 0,line:"done",toValue:void 0,type:"start event"}},{timestamp:t.endTime,value:0,change:{fromValue:void 0,key:void 0,line:"done",toValue:void 0,type:"end event"}}])}),test("repeated state updates on incomplete issue",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.changes={500:this.addAndEstimate("KEY-1",9),1800:[this.moveToNotDone("KEY-1")],1900:[this.changeEstimate("KEY-1",9)],2e3:[this.addToSprint("KEY-1")]};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.work,[{timestamp:t.startTime,value:0,change:{fromValue:void 0,key:void 0,line:"done",toValue:void 0,type:"start event"}},{timestamp:t.endTime,value:0,change:{fromValue:void 0,key:void 0,line:"done",toValue:void 0,type:"end event"}}]),deepEqual(i.scope,[{timestamp:t.startTime,value:9,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"start event"}},{timestamp:t.endTime,value:9,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"end event"}}])}),test("repeated state updates on complete issue",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.changes={500:this.addAndEstimate("KEY-1",9),600:[this.moveToDone("KEY-1")],1900:[this.changeEstimate("KEY-1",9)],1800:[this.moveToDone("KEY-1")],2e3:[this.removeFromSprint("KEY-1")]};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.work,[{timestamp:t.startTime,value:0,change:{fromValue:void 0,key:void 0,line:"done",toValue:void 0,type:"start event"}},{timestamp:t.endTime,value:0,change:{fromValue:void 0,key:void 0,line:"done",toValue:void 0,type:"end event"}}]),deepEqual(i.scope,[{timestamp:t.startTime,value:0,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"start event"}},{timestamp:t.endTime,value:0,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"end event"}}])}),test("work completed then uncompleted during sprint",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.changes={500:this.addAndEstimate("KEY-1",9),600:this.addAndEstimate("KEY-2",9),1700:[this.moveToDone("KEY-1")],1800:[this.moveToNotDone("KEY-1")]};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.work,[{timestamp:t.startTime,value:0,change:{fromValue:void 0,key:void 0,line:"done",toValue:void 0,type:"start event"}},{timestamp:1700,value:9,change:{fromValue:0,key:"KEY-1",line:"done",toValue:9,type:"issue done"}},{timestamp:1800,value:0,change:{fromValue:9,key:"KEY-1",line:"done",toValue:0,type:"issue not done"}},{timestamp:t.endTime,value:0,change:{fromValue:void 0,key:void 0,line:"done",toValue:void 0,type:"end event"}}]),deepEqual(i.scope,[{timestamp:t.startTime,value:18,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"start event"}},{timestamp:t.endTime,value:18,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"end event"}}])}),test("work completed then estimated updated during sprint",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.changes={500:this.addAndEstimate("KEY-1",9),600:this.addAndEstimate("KEY-2",9),1700:[this.moveToDone("KEY-1")],1800:[this.changeEstimate("KEY-1",1)]};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.work,[{timestamp:t.startTime,value:0,change:{fromValue:void 0,key:void 0,line:"done",toValue:void 0,type:"start event"}},{timestamp:1700,value:9,change:{fromValue:0,key:"KEY-1",line:"done",toValue:9,type:"issue done"}},{timestamp:1800,value:1,change:{fromValue:9,key:"KEY-1",line:"done",toValue:1,type:"estimate update"}},{timestamp:t.endTime,value:1,change:{fromValue:void 0,key:void 0,line:"done",toValue:void 0,type:"end event"}}]),deepEqual(i.scope,[{timestamp:t.startTime,value:18,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"start event"}},{timestamp:1800,value:10,change:{fromValue:9,key:"KEY-1",line:"scope",toValue:1,type:"estimate update"}},{timestamp:t.endTime,value:10,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"end event"}}])}),test("unestimated completed issue estimated during sprint",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.changes={500:this.addWithoutEstimate("KEY-1"),600:this.addAndEstimate("KEY-2",9),1700:[this.moveToDone("KEY-1")],1800:[this.changeEstimate("KEY-1",1)]};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.work,[{timestamp:t.startTime,value:0,change:{fromValue:void 0,key:void 0,line:"done",toValue:void 0,type:"start event"}},{timestamp:1700,value:0,change:{fromValue:0,key:"KEY-1",line:"done",toValue:0,type:"issue done"}},{timestamp:1800,value:1,change:{fromValue:0,key:"KEY-1",line:"done",toValue:1,type:"estimate update"}},{timestamp:t.endTime,value:1,change:{fromValue:void 0,key:void 0,line:"done",toValue:void 0,type:"end event"}}]),deepEqual(i.scope,[{timestamp:t.startTime,value:9,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"start event"}},{timestamp:1800,value:10,change:{fromValue:0,key:"KEY-1",line:"scope",toValue:1,type:"estimate update"}},{timestamp:t.endTime,value:10,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"end event"}}])}),test("completed issue with estimate removed from sprint",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.changes={600:this.addAndEstimate("KEY-1",9),1700:[this.moveToDone("KEY-1")],1800:[this.removeFromSprint("KEY-1")]};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.work,[{timestamp:t.startTime,value:0,change:{fromValue:void 0,key:void 0,line:"done",toValue:void 0,type:"start event"}},{timestamp:1700,value:9,change:{fromValue:0,key:"KEY-1",line:"done",toValue:9,type:"issue done"}},{timestamp:1800,value:0,change:{fromValue:9,key:"KEY-1",line:"done",toValue:0,type:"issue removed"}},{timestamp:t.endTime,value:0,change:{fromValue:void 0,key:void 0,line:"done",toValue:void 0,type:"end event"}}]),deepEqual(i.scope,[{timestamp:t.startTime,value:9,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"start event"}},{timestamp:1800,value:0,change:{fromValue:9,key:"KEY-1",line:"scope",toValue:0,type:"issue removed"}},{timestamp:t.endTime,value:0,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"end event"}}])}),test("completed issue without estimate removed from sprint",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.changes={600:this.addAndEstimate("KEY-1",9),700:this.addWithoutEstimate("KEY-2"),1700:[this.moveToDone("KEY-2")],1800:[this.removeFromSprint("KEY-2")]};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.work,[{timestamp:t.startTime,value:0,change:{fromValue:void 0,key:void 0,line:"done",toValue:void 0,type:"start event"}},{timestamp:1700,value:0,change:{fromValue:0,key:"KEY-2",line:"done",toValue:0,type:"issue done"}},{timestamp:1800,value:0,change:{fromValue:0,key:"KEY-2",line:"done",toValue:0,type:"issue removed"}},{timestamp:t.endTime,value:0,change:{fromValue:void 0,key:void 0,line:"done",toValue:void 0,type:"end event"}}]),deepEqual(i.scope,[{timestamp:t.startTime,value:9,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"start event"}},{timestamp:1800,value:9,change:{fromValue:0,key:"KEY-2",line:"scope",toValue:0,type:"issue removed"}},{timestamp:t.endTime,value:9,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"end event"}}])}),test("completed issue estimated during sprint",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.changes={600:this.addAndEstimate("KEY-1",9),700:this.addAndEstimate("KEY-2",0),1700:[this.moveToDone("KEY-2")],1800:[this.changeEstimate("KEY-2",1)]};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.work,[{timestamp:t.startTime,value:0,change:{fromValue:void 0,key:void 0,line:"done",toValue:void 0,type:"start event"}},{timestamp:1700,value:0,change:{fromValue:0,key:"KEY-2",line:"done",toValue:0,type:"issue done"}},{timestamp:1800,value:1,change:{fromValue:0,key:"KEY-2",line:"done",toValue:1,type:"estimate update"}},{timestamp:t.endTime,value:1,change:{fromValue:void 0,key:void 0,line:"done",toValue:void 0,type:"end event"}}]),deepEqual(i.scope,[{timestamp:t.startTime,value:9,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"start event"}},{timestamp:1800,value:10,change:{fromValue:0,key:"KEY-2",line:"scope",toValue:1,type:"estimate update"}},{timestamp:t.endTime,value:10,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"end event"}}])}),test("completed issue with estimate added during sprint",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.changes={600:this.addAndEstimate("KEY-1",9),1600:this.addAndEstimate("KEY-2",1).concat([this.moveToDone("KEY-2")])};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.work,[{timestamp:t.startTime,value:0,change:{fromValue:void 0,key:void 0,line:"done",toValue:void 0,type:"start event"}},{timestamp:1600,value:1,change:{fromValue:0,key:"KEY-2",line:"done",toValue:1,type:"issue done"}},{timestamp:t.endTime,value:1,change:{fromValue:void 0,key:void 0,line:"done",toValue:void 0,type:"end event"}}]),deepEqual(i.scope,[{timestamp:t.startTime,value:9,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"start event"}},{timestamp:1600,value:10,change:{fromValue:0,key:"KEY-2",line:"scope",toValue:1,type:"issue added"}},{timestamp:t.endTime,value:10,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"end event"}}])}),test("issue removed from sprint, estimate updated, then done, then added to sprint",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.changes={600:this.addAndEstimate("KEY-1",9),1600:[this.removeFromSprint("KEY-1")],1700:[this.changeEstimate("KEY-1",5)],1800:[this.moveToDone("KEY-1")],1900:[this.addToSprint("KEY-1")]};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.work,[{timestamp:t.startTime,value:0,change:{fromValue:void 0,key:void 0,line:"done",toValue:void 0,type:"start event"}},{timestamp:1900,value:5,change:{fromValue:0,key:"KEY-1",line:"done",toValue:5,type:"issue added"}},{timestamp:t.endTime,value:5,change:{fromValue:void 0,key:void 0,line:"done",toValue:void 0,type:"end event"}}]),deepEqual(i.scope,[{timestamp:t.startTime,value:9,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"start event"}},{timestamp:1600,value:0,change:{fromValue:9,key:"KEY-1",line:"scope",toValue:0,type:"issue removed"}},{timestamp:1900,value:5,change:{fromValue:0,key:"KEY-1",line:"scope",toValue:5,type:"issue added"}},{timestamp:t.endTime,value:5,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"end event"}}])}),test("issue complete, removed from sprint, then uncompleted, then added to sprint",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.changes={600:this.addAndEstimate("KEY-1",9),1500:[this.moveToDone("KEY-1")],1600:[this.removeFromSprint("KEY-1")],1700:[this.moveToNotDone("KEY-1")],1900:[this.addToSprint("KEY-1")]};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.work,[{timestamp:t.startTime,value:0,change:{fromValue:void 0,key:void 0,line:"done",toValue:void 0,type:"start event"}},{timestamp:1500,value:9,change:{fromValue:0,key:"KEY-1",line:"done",toValue:9,type:"issue done"}},{timestamp:1600,value:0,change:{fromValue:9,key:"KEY-1",line:"done",toValue:0,type:"issue removed"}},{timestamp:t.endTime,value:0,change:{fromValue:void 0,key:void 0,line:"done",toValue:void 0,type:"end event"}}]),deepEqual(i.scope,[{timestamp:t.startTime,value:9,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"start event"}},{timestamp:1600,value:0,change:{fromValue:9,key:"KEY-1",line:"scope",toValue:0,type:"issue removed"}},{timestamp:1900,value:9,change:{fromValue:0,key:"KEY-1",line:"scope",toValue:9,type:"issue added"}},{timestamp:t.endTime,value:9,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"end event"}}])}),test("issue complete, estimated twice before sprint, then reopened during sprint",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.changes={600:this.addAndEstimate("KEY-1",1),700:this.addAndEstimate("KEY-1",3),800:[this.moveToDone("KEY-1")],1100:[this.moveToNotDone("KEY-1")]};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.work,[{timestamp:t.startTime,value:0,change:{fromValue:void 0,key:void 0,line:"done",toValue:void 0,type:"start event"}},{timestamp:t.endTime,value:0,change:{fromValue:void 0,key:void 0,line:"done",toValue:void 0,type:"end event"}}]),deepEqual(i.scope,[{timestamp:t.startTime,value:0,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"start event"}},{timestamp:1100,value:3,change:{fromValue:0,key:"KEY-1",line:"scope",toValue:3,type:"issue not done"}},{timestamp:t.endTime,value:3,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"end event"}}])}),test("unestimated issue reopened during sprint",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.endTime=1e4,t.changes={100:this.addWithoutEstimate("KEY-1"),200:[this.moveToDone("KEY-1")],1300:[this.moveToNotDone("KEY-1")]};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i,{now:t.now,start:t.startTime,startKeys:[],end:t.endTime,endKeys:["KEY-1"],sprintCompleted:!0,issueToSummary:[],nonWorkPeriods:[],work:[{timestamp:t.startTime,value:0,change:{fromValue:void 0,key:void 0,line:"done",toValue:void 0,type:"start event"}},{timestamp:t.endTime,value:0,change:{fromValue:void 0,key:void 0,line:"done",toValue:void 0,type:"end event"}}],scope:[{timestamp:t.startTime,value:0,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"start event"}},{timestamp:1300,value:0,change:{fromValue:0,key:"KEY-1",line:"scope",toValue:0,type:"issue not done"}},{timestamp:t.endTime,value:0,change:{fromValue:void 0,key:void 0,line:"scope",toValue:void 0,type:"end event"}}],statisticField:t.statisticField,rapidViewId:t.rapidViewId,estimatedIssueEvents:0})}),test("no issues at all",function(){var t=this.emptyClosedSprint(),i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.startKeys,[]),strictEqual(i.endKeys.length,0)}),test("issue only added after sprint start",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.changes={1100:this.addWithoutEstimate("KEY-1")};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.startKeys,[]),deepEqual(i.endKeys,["KEY-1"])}),test("removed issue before sprint start",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.changes={100:this.addWithoutEstimate("KEY-1"),300:[this.removeFromSprint("KEY-1")]};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.startKeys,[]),deepEqual(i.endKeys,[])}),test("removed issue during sprint",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.endTime=1e4,t.changes={100:this.addWithoutEstimate("KEY-1"),1300:[this.removeFromSprint("KEY-1")]};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.startKeys,["KEY-1"]),deepEqual(i.endKeys,[])}),test("removed issue after sprint",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.endTime=1e4,t.changes={100:this.addWithoutEstimate("KEY-1"),10300:[this.removeFromSprint("KEY-1")]};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.startKeys,["KEY-1"]),deepEqual(i.endKeys,["KEY-1"])}),test("exclude issues done before sprint starts",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.changes={100:this.addWithoutEstimate("KEY-1"),200:[this.moveToDone("KEY-1")]};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.startKeys,[]),deepEqual(i.endKeys,[])}),test("include issues un-done before sprint starts",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.endTime=1e4,t.changes={100:this.addWithoutEstimate("KEY-1"),200:[this.moveToDone("KEY-1")],300:[this.moveToNotDone("KEY-1")]};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.startKeys,["KEY-1"]),deepEqual(i.endKeys,["KEY-1"])}),test("include issues un-done after sprint starts",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.endTime=1e4,t.changes={100:this.addWithoutEstimate("KEY-1"),200:[this.moveToDone("KEY-1")],1300:[this.moveToNotDone("KEY-1")]};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.startKeys,[]),deepEqual(i.endKeys,["KEY-1"])}),test("include issues done during sprint",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.endTime=1e4,t.changes={100:this.addWithoutEstimate("KEY-1"),1200:[this.moveToDone("KEY-1")]};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.startKeys,["KEY-1"]),deepEqual(i.endKeys,["KEY-1"])}),test("include issues done after sprint",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.endTime=1e4,t.changes={100:this.addWithoutEstimate("KEY-1"),10200:[this.moveToDone("KEY-1")]};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.startKeys,["KEY-1"]),deepEqual(i.endKeys,["KEY-1"])}),test("issue keys sorted for sprint start",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.changes={100:this.addWithoutEstimate("KEY-7"),200:this.addWithoutEstimate("KEY-4"),300:this.addWithoutEstimate("KEY-5"),400:this.addWithoutEstimate("KEY-2"),500:this.addWithoutEstimate("KEY-3"),600:this.addWithoutEstimate("KEY-1"),800:this.addWithoutEstimate("KEY-18"),700:this.addWithoutEstimate("KEY-6")};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));deepEqual(i.startKeys,["KEY-1","KEY-2","KEY-3","KEY-4","KEY-5","KEY-6","KEY-7","KEY-18"])}),test("issue keys sorted for sprint end",function(){var t=this.emptyClosedSprint();t.startTime=1e3,t.changes={100:this.addWithoutEstimate("KEY-7"),200:this.addWithoutEstimate("KEY-4"),300:this.addWithoutEstimate("KEY-5"),400:this.addWithoutEstimate("KEY-2"),500:this.addWithoutEstimate("KEY-3"),600:this.addWithoutEstimate("KEY-1"),800:this.addWithoutEstimate("KEY-18"),700:this.addWithoutEstimate("KEY-6")};var i=e(this.service.getBurnupModelFromScopeBurndownModel(t));
deepEqual(i.endKeys,["KEY-1","KEY-2","KEY-3","KEY-4","KEY-5","KEY-6","KEY-7","KEY-18"])}),test("current time after end time and sprint open",function(){var e=this.emptyClosedSprint();e.now=5e3,e.endTime=1e3,delete e.completeTime;var t=this.service.getBurnupModelFromScopeBurndownModel(e).chartData;equal(5e3,t.end),equal(!1,t.sprintCompleted)}),test("current time after end time and sprint closed",function(){var e=this.emptyClosedSprint();e.now=5e3,e.endTime=1e4,e.completeTime=6e3;var t=this.service.getBurnupModelFromScopeBurndownModel(e).chartData;equal(6e3,t.end),equal(!0,t.sprintCompleted)}),test("current time before end time and sprint open",function(){var e=this.emptyClosedSprint();e.now=1e3,e.endTime=5e3,delete e.completeTime;var t=this.service.getBurnupModelFromScopeBurndownModel(e).chartData;equal(5e3,t.end),equal(!1,t.sprintCompleted)}),test("current time before end time and sprint closed",function(){var e=this.emptyClosedSprint();e.now=1e3,e.endTime=5e3,e.completeTime=6e3;var t=this.service.getBurnupModelFromScopeBurndownModel(e).chartData;equal(6e3,t.end),equal(!0,t.sprintCompleted)});var e=function(e){var t=e.chartData;return delete t.formatDate,delete t.formatEventType,delete t.formatShortDate,delete t.formatStatistic,t}});