/* global c3, GH */

(function (multipleCharts, c3){
    'use strict';

    function ScopeBurndownBySprintChartLegend () {

        function renderLegendBar(selection, barClass, seriesClass) {
            return selection
                .append('g')
                .classed(barClass, true)
                .append('rect')
                .attr('width', '100%')
                .attr('height', '100%')
                .classed(seriesClass, true);
        }

        function renderSplitLegendBar(selection, barClass, seriesClass1, seriesClass2) {
            var g = selection.append('g').classed(barClass, true);
            g.append('rect').classed(seriesClass1, true).attr({
                y: 0,
                width: '100%',
                height: '50%'
            });
            g.append('rect').classed(seriesClass2, true).attr({
                y: '50%',
                width: '100%',
                height: '50%'
            });
            return g;
        }

        var completed = function(selection) {
            renderLegendBar(selection, 'ghx-bar-sprint', 'ghx-series-0');
        };

        var remaining = function(selection) {
            renderLegendBar(selection, 'ghx-bar-sprint', 'ghx-series-1');
        };

        var added = function(selection) {
            renderLegendBar(selection, 'ghx-bar-sprint', 'ghx-series-2');
        };

        var forecast = function(selection) {
            renderSplitLegendBar(selection, 'ghx-prediction', 'ghx-series-0', 'ghx-series-1');
        };

        return c3.component('scopeBurndownBySprintChartLegend')
            .extend(multipleCharts())
            .charts([
                completed,
                forecast,
                remaining,
                added
            ]);
    }

    GH.Reports.ScopeBurndownBySprintChartLegend = ScopeBurndownBySprintChartLegend;
}(GH.Reports.multipleCharts, c3));
