GH.Reports.ControlChartBrush = function () {
    return c3.brush().elementClass('ghx-chart-brush').enter(function () {
        var self = this;
        // cancel drag if the user clicks outside the chart
        AJS.$(document).on('click mouseup', function (e) {
            if (AJS.$(e.target).closest(self.parent().selection().node()).size() === 0) {
                self.cancelDrag();
            }
        });
        // cancel drag if the user presses the escape key
        AJS.$(document).on('keydown', function (e) {
            if (e.keyCode === 27) {
                self.cancelDrag();
            }
        });
    }).onDrag(function () {
        // ensure we can't start a drag if we're dragging inside a dialog
        if (AJS.$(d3.event.target).closest(this.parent().selection().node()).size() > 0) {
            GH.Reports.ControlChartDialog.hide();
        } else {
            this.cancelDrag();
        }
    }).onEndDrag(function (range) {
        var self = this;
        // don't zoom if we're only selecting 5px
        if (range[1] - range[0] < 5) {
            return;
        }
        range = _.map(range, function (elem) {
            return self.parent().xScale().invert(elem);
        });
        // update the timeframes
        GH.Reports.ControlChartController.getFilterOptions().timeFrame.setSimpleDates(range[0], range[1]);
        GH.Reports.ControlChartController.update();
    });
};