/**
 * A service that provides conversion between new and old chart configs.
 * - non-working days
 */
(function () {

    /**
     * Get RapidBoard saved state
     *
     * @param {number} rapidViewId
     * @param {string} chartId
     * @returns {*}
     */
    function getConfigForChart (rapidViewId, chartId) {
        var config = GH.RapidBoard.State.getBoardSetting(
            rapidViewId,
            'chart.config.' + chartId,
            {}
        );
        return config;
    }

    function ChartNWDConfigService () {};

    ChartNWDConfigService.prototype = {

        /**
         * Transform old non-working days config to new board state.
         *
         * @param rapidViewId
         * @param chartId
         */
        mapOldConfigToNewConfig: function (rapidViewId, chartId) {
            var config = getConfigForChart(rapidViewId, chartId);
            var nwdSetting = GH.RapidBoard.State.getCycleTimeCalculationType();

            // Include non-working days in cycle time calculation?
            config.includeNonWorkingDays = (nwdSetting === 'total');

            GH.RapidBoard.State.setBoardSetting('chart.config.' + chartId, config);
        },

        /**
         * Transform new non-working days config to old localStorage location.
         *
         * @param {number} rapidViewId
         * @param {string} chartId
         */
        mapNewConfigToOldConfig: function (rapidViewId, chartId) {
            var config = getConfigForChart(rapidViewId, chartId);
            var nwdSetting = config.includeNonWorkingDays ? 'total' : 'workingDays';

            // Include non-working days in cycle time calculation?
            GH.RapidBoard.State.setCycleTimeCalculationType(nwdSetting);
        }
    }

    GH.ChartNWDConfigService = ChartNWDConfigService;
    GH.chartNWDConfigService = new ChartNWDConfigService();
}());