AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid"], function () {
    module("loadReportData", {
        setup: function setup() {
            GH.Test.setUpFakeServer(this);
            GH.VelocityChartController.displayed = true;
            GH.VelocityChartController.rapidViewConfig.estimationStatistic = {
                renderer: "duration"
            };
        },
        teardown: function teardown() {
            GH.Test.restoreServer(this);
        }
    });

    test("Successful Ajax request passes to process sprint data", sinon.test(function () {
        this.stub(GH.VelocityChartView, "showVelocityChart");

        GH.Test.respondToGetWith200(this, "/rapid/charts/velocity.json", {});

        GH.VelocityChartController.loadReportData();

        this.server.respond();

        ok(GH.VelocityChartView.showVelocityChart.called, "Called success method");
    }));

    test("Failed request hides the spinner", sinon.test(function () {
        this.stub(GH.VelocityChartView, "showVelocityChart");
        this.stub(GH.ChartView, "hideSpinner");

        GH.Test.respondToGetWith500(this, "/rapid/charts/velocity.json", {});

        GH.VelocityChartController.loadReportData();

        this.server.respond();

        ok(!GH.VelocityChartView.showVelocityChart.called, "Does not call process function on failure");
        ok(GH.ChartView.hideSpinner.called, "Hid Spinner");
    }));
});