define('jira-agile/rapid/ui/chart/velocity-chart-controller', [
    'jquery',
    'jira-agile/rapid/analytics-tracker',
    'jira-agile/rapid/logger',
    'jira-agile/rapid/state/rapid-board-state',
    'jira-agile/rapid/ui/chart/chart-view',
    'jira-agile/rapid/ajax',
    'jira-agile/rapid/time-format',
    'jira-agile/rapid/number-format'
], function ($, AnalyticsTracker, Logger, RapidBoardState, ChartView, GHAjax, TimeFormat, NumberFormat) {
    const SprintRetrospectiveView = GH.SprintRetrospectiveView;
    const VelocityChartView = GH.VelocityChartView;
    const RapidViewConfig = GH.RapidViewConfig;

    const Controller = {
        id: 'velocityChart',
        displayed: false,
        rapidViewData: {},
        rapidViewConfig: {}
    };
    /**
     * @type module:jira-agile/rapid/analytics-tracker
     */
    Controller.analytics = new AnalyticsTracker('gh.report.velocityChart');

    Controller.setRapidView = function (rapidViewData) {
        Controller.rapidViewData = rapidViewData || {};
    };

    Controller.isApplicable = function (rapidViewConfig) {
        return rapidViewConfig.sprintSupportEnabled;
    };

    /**
     * Provide params to create the "normalized" object for this report
     * No params for this report
     */
    Controller.getNormalizedFromInternal = function () {
        return {};
    };

    /**
     * Interpret the normalized params and identify the relevant ones to be converted into URL params
     * No params for this report
     */
    Controller.toUrl = function () {
        return {};
    };

    /**
     * Update state from normalized state
     * @param params
     */
    Controller.updateInternalFromNormalized = function (params) {
        // nothing to do
    };

    /**
     * Get normalized state for this chart type
     */
    Controller.getNormalizedFromUrl = function (params) {
        return {};
    };

    Controller.init = function () {
        // no-op
    };

    Controller.show = function () {
        Logger.log('Controller.show', Logger.Contexts.ui);
        Controller.displayed = true;

        // stop here if haven't got a view
        if (!Controller.rapidViewData) {
            return;
        }

        RapidBoardState.pushState();
        // render the view
        Controller.renderChartView();

        Controller.analytics.trigger("show");
    };

    Controller.hide = function () {
        Logger.log('Controller.hide', Logger.Contexts.ui);
        Controller.displayed = false;

        SprintRetrospectiveView.hide();

        // unbind listeners
        $(GH).off('.' + Controller.id);
    };

    Controller.renderChartView = function () {
        // controls
        Controller.initializeControls();

        // render the view
        ChartView.getChartContentElem(true).html(GH.tpl.velocity.renderReportBody());

        // show the spinner
        ChartView.showSpinner();

        // then load the chart
        Controller.loadRapidViewConfig();
    };

    /**
     * Initializes controls, such as time frame and filters
     */
    Controller.initializeControls = function () {
        // controls structure
        $('#ghx-chart-controls').hide();
    };

    Controller.loadRapidViewConfig = function () {
        var callback = function (data) {
            // ignore if we are not displayed anymore
            if (!Controller.displayed) {
                return;
            }
            Controller.rapidViewConfig = data;
            Controller.loadReportData();
        };

        RapidViewConfig.fetchConfiguration(Controller.rapidViewData.id).done(callback);
    };

    Controller.loadReportData = function () {

        // load the burndown datavar
        GHAjax.get({
            url: '/rapid/charts/velocity.json',
            data: {
                rapidViewId: Controller.rapidViewConfig.id

            }
        }, 'rapidChartData.velocity')
            .done(Controller.processChartData)
            .fail(ChartView.hideSpinner);
    };

    Controller.processChartData = function (data) {
        if (!Controller.displayed) {
            return;
        }
        // get the renderer for the estimationstatistic
        var renderer;
        if (Controller.rapidViewConfig.estimationStatistic.renderer === 'duration') {
            renderer = TimeFormat.formatShortDurationForTimeTrackingConfiguration;
        } else {
            renderer = NumberFormat.format;
        }
        // update text values.
        _.each(data.velocityStatEntries, function (entry) {
            entry.estimated.text = renderer(entry.estimated.value);
            entry.completed.text = renderer(entry.completed.value);
        });

        VelocityChartView.showVelocityChart(data);
    };

    return Controller;
});
AJS.namespace('GH.VelocityChartController', null, require('jira-agile/rapid/ui/chart/velocity-chart-controller'));
