/**
 * Manages the url state for the report tab
 */
GH.ReportUrlState = {};

GH.ReportUrlState.self = "ReportUrlState";

/**
 * Is this state applicable for the given normalized state
 * @param normalized
 */
GH.ReportUrlState.isApplicable = function(normalized) {
    return normalized.mode === 'report';
};

/**
 * Normalizes the url state for the plan specific values.
 * @param urlParams the parsed url parameters
 * @param normalized normalized parameters
 */
GH.ReportUrlState.getNormalizedFromUrl = function(urlParams, normalized) {
    GH.ReportController.init();
    // chart type
    var chartId = normalized['chart'] = GH.RapidBoard.UrlState.normalizeStringParam(urlParams['chart'], ''); // let report controller decide the default (which is board specific)
    var chart = GH.ReportController.getChart(chartId);

    if (chart) {
        _.defaults(normalized, chart.controller.getNormalizedFromUrl(urlParams));
    }
};

/**
 * Transforms the normalized url parameters into actual url parameters
 * @param normalized the normalized params
 * @param urlParams the url params
 */
GH.ReportUrlState.toUrl = function(normalized, urlParams) {
    // chart type
    var chartId = urlParams.chart = normalized.chart;
    var chart = GH.ReportController.getChart(chartId);

    // copy the relevant values per the chart controller
    if (chart) {
        _.defaults(urlParams, chart.controller.toUrl(normalized));
    }
};

/**
 * Get the normalized state from the app
 * @param normalized the normalized state to put the values into
 */
GH.ReportUrlState.getNormalizedFromInternal = function(normalized) {
    GH.ReportController.init();
    var chart = GH.ReportController.getCurrentChart();

    // chart type
    normalized.chart = GH.RapidBoard.State.getChartType();

    // copy relevant values per the chart controller
    if (chart) {
        _.defaults(normalized, chart.controller.getNormalizedFromInternal());
    }
};

/**
 * Update the app with the values stored in the normalized state
 * @param normalized the normalized state to update the values from
 */
GH.ReportUrlState.updateInternalFromNormalized = function(normalized) {
    GH.ReportController.init();
    GH.RapidBoard.State.setChartType(normalized['chart']);

    var chart = GH.ReportController.getChart(normalized.chart);
    if (chart) {
        chart.controller.updateInternalFromNormalized(normalized);
    }
};
