AJS.test.require(['com.pyxis.greenhopper.jira:gh-test-common', 'com.pyxis.greenhopper.jira:gh-rapid'], function() {
    var $ = require('jquery');
    var BurndownChartController = require('jira-agile/rapid/ui/chart/burndown-chart-controller');
    var ControlChartController = require('jira-agile/rapid/ui/chart/v2/controlchart/control-chart-controller');
    var EpicBurndownReportController = require('jira-agile/rapid/ui/chart/v2/epicburndown/epic-burndown-report-controller');
    var GlobalEvents = require('jira-agile/rapid/global-events');
    var ReleaseBurndownReportController = require('jira-agile/rapid/ui/chart/v2/releaseburndown/release-burndown-report-controller');
    var ReportController = require('jira-agile/rapid/ui/chart/report-controller');
    var VersionReportController = require('jira-agile/rapid/ui/chart/version-report-controller');

    GlobalEvents.trigger('pre-initialization');

    module('Showing the current report');

    test('Tests that one chart is visible while the rest are hidden, the chart nav is rendered correctly', sinon.test(function() {
        QUnit.GhFixtures.addFixture('' +
            '<div id="ghx-chart-panel-content"></div>' +
            '<ul id="ghx-chart-nav"></ul>');

        ReportController.rapidViewConfig = {
            sprintSupportEnabled: true
        };
        ReportController.initCharts();

        BurndownChartController.displayed = true;
        GH.SprintRetrospectiveController.displayed = true;
        GH.EpicReportController.displayed = true;
        ReportController.getChart(ControlChartController.id).controller.displayed = true;
        ReportController.getChart(EpicBurndownReportController.id).controller.displayed = true;
        ReportController.getChart(ReleaseBurndownReportController.id).controller.displayed = true;
        GH.CFDController.displayed = true;

        this.stub(GH.RapidBoard.State, 'getBoardSettings').returns({
            chartType: VersionReportController.id
        });
        this.stub(VersionReportController, 'show');

        ReportController.showChart();

        ok($('#ghx-chart-panel-content').is(':visible'), 'Chart should be visible');
        ok(VersionReportController.show.called, 'Showed version report controller');

        ok(!BurndownChartController.displayed);
        ok(!GH.SprintRetrospectiveController.displayed);
        ok(!GH.VelocityChartController.displayed);
        ok(!GH.EpicReportController.displayed);
        ok(!ReportController.getChart(ControlChartController.id).controller.displayed);
        ok(!ReportController.getChart(EpicBurndownReportController.id).controller.displayed);
        ok(!ReportController.getChart(ReleaseBurndownReportController.id).controller.displayed);
        ok(!GH.CFDController.displayed);

        // check reports menu set up correctly
        equal($('#ghx-chart-nav .aui-nav-selected').text().trim(), 'gh.rapid.charts.version.name', 'Correct report selected');

        equal($('#ghx-chart-nav li').length, 9, 'All reports listed in menu');
    }));
});
