AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid"], function() {
    module("Building a JQL query");

    test("returns the correct query for a single issue", function() {
        var issue = GH.IssueTest.createIssueObjectWithKey("GH-1");

        var jql = GH.ChartUtils.createIssueJql([issue]);

        equal(jql, "issueKey in (GH-1)");
    });

    test("returns the correct query for a list of issues", function() {

        var issues = [
            GH.IssueTest.createIssueObjectWithKey("GH-1"),
            GH.IssueTest.createIssueObjectWithKey("GH-2"),
            GH.IssueTest.createIssueObjectWithKey("GH-3")
        ];

        var jql = GH.ChartUtils.createIssueJql(issues);

        equal(jql, "issueKey in (GH-1,GH-2,GH-3)");
    });

    module("Date formatting with moment.js", {
        setup: function() {
            this.momentDateFormat = GH.ChartTimeFrames.momentDateFormat;
            this.momentTimeFormat = GH.ChartTimeFrames.momentTimeFormat;
        },
        teardown: function() {
            GH.ChartTimeFrames.momentDateFormat = this.momentDateFormat;
            GH.ChartTimeFrames.momentTimeFormat = this.momentTimeFormat;
        }
    });

    test("check that GH.ChartTimeFrames.momentTimeFormat is defined", function() {
        ok(GH.ChartTimeFrames.momentTimeFormat);
    });

    test("check that GH.ChartTimeFrames.momentDateFormat is defined", function() {
        ok(GH.ChartTimeFrames.momentDateFormat);
    });

    test("check renderUTCMilliesAsDateWithoutTime is using GH.ChartTimeFrames.momentDateFormat for formatting", sinon.test(function() {
        var format = "We are using momentDateFormat",
            time = 1234567890000;

        GH.ChartTimeFrames.momentDateFormat = format;
        this.stub(GH.ChartUtils, "renderUTCMillisInFormat");
        GH.ChartUtils.renderUTCMillisAsDateWithoutTime(time);

        ok(GH.ChartUtils.renderUTCMillisInFormat.called);
        deepEqual(GH.ChartUtils.renderUTCMillisInFormat.firstCall.args, [time, format]);
    }));

    test("check renderUTCMilliesAsDate is using GH.ChartTimeFrames.momentTimeFormat for formatting", sinon.test(function() {
        var format = "We are using momentTimeFormat",
            time = 1234567890000;

        GH.ChartTimeFrames.momentTimeFormat = format;
        this.stub(GH.ChartUtils, "renderUTCMillisInFormat");
        GH.ChartUtils.renderUTCMillisAsDate(time);

        ok(GH.ChartUtils.renderUTCMillisInFormat.called);
        deepEqual(GH.ChartUtils.renderUTCMillisInFormat.firstCall.args, [time, format]);
    }));
});
