define("jira-agile/rapid/ui/chart/changes-report-model",["require"],function(t){"use strict";var e=t("underscore"),i=t("jira-agile/rapid/ui/chart/burndown-rate"),s=t("jira-agile/rapid/ui/chart/burndown-table-producer"),a=t("jira-agile/rapid/ui/chart/burndown-timeline-producer"),n=t("jira-agile/rapid/ui/chart/chart-colors"),r=t("jira-agile/rapid/rapid-board-data-loader"),o=GH.FlotChartUtils,u=GH.ChartUtils,c=GH.TimeFormat,d=GH.NumberFormat,h=function(){};return h.prototype.setParams=function(t){this.statistic=t.statistic,this.issueAddedText=t.issueAddedText,this.issueRemovedText=t.issueRemovedText,this.startText=t.startText},h.prototype.setRawData=function(t){this.data=t,this.processData()},h.prototype.processData=function(){this.resolveIssueEntities(),this.ensureIssuesHaveEstimateText(),this.makeStatisticsValuesRenderable()},h.prototype.setRawChartData=function(t){this.chartData=t,this.processChartData()},h.prototype.getStartTime=function(){return this.chartData.startTime},h.prototype.processChartData=function(){this.chartData.endTime||(this.chartData.endTime=this.chartData.now),i.setRateData(this.chartData.workRateData);var t=a.ProgressConsumer;this.timelineData=a.calculateTimelineData(this.chartData,t),this.calculateSeries()},h.prototype.hasIssues=function(){var t=this.getReportContent();return t?t.completedIssues.length>0||t.incompleteEstimatedIssues.length>0||t.incompleteUnestimatedIssues.length>0:!!this.chartData&&!e.isEmpty(this.chartData.changes)},h.prototype.getReportContent=function(){if(this.data)return this.data.contents},h.prototype.getRenderer=function(){return this.statistic.renderer},h.prototype.isIssueCountStatistic=function(){return"issueCount"===this.statistic.typeId},h.prototype.isTimeTracking=function(){return"timeSpent"===this.statistic.fieldId},h.prototype.shouldAddToSeries=function(t,i){var s=!1;return e.each(i,function(e){s=s||e.deltas&&0!==e.deltas[t.id]}),s},h.prototype.getAllSeriesDefinitions=function(){var t=this.statistic.name;return{totalEstimate:{id:"totalEstimate",label:AJS.I18n.getText("gh.rapid.charts.progress.total.estimate",t),renderer:this.getRenderer(),statisticName:t},completedEstimate:{id:"completedEstimate",label:AJS.I18n.getText("gh.rapid.charts.progress.total.complete",t),renderer:this.getRenderer(),statisticName:t},issueCount:{id:"issueCount",label:AJS.I18n.getText("gh.rapid.charts.progress.total.issuecount"),renderer:"number",statisticName:AJS.I18n.getText("gh.rapid.charts.progress.issuecount")},unestimatedIssueCount:{id:"unestimatedIssueCount",label:AJS.I18n.getText("gh.rapid.charts.progress.unestimated.issues"),renderer:"number",statisticName:AJS.I18n.getText("gh.rapid.charts.progress.issuecount")}}},h.prototype.calculateSeries=function(){var t=[],i=this.getAllSeriesDefinitions();this.isIssueCountStatistic()?(t.push(e.defaults({color:n.scope,yaxis:1,fill:.3,lineWidth:1},i.totalEstimate)),t.push(e.defaults({color:n.completed,yaxis:1,fill:.2,lineWidth:1},i.completedEstimate))):(t.push(e.defaults({color:n.scope,yaxis:1,fill:.3,lineWidth:1},i.totalEstimate)),t.push(e.defaults({color:n.completed,yaxis:1,fill:.2,lineWidth:1},i.completedEstimate)),t.push(e.defaults({color:n.issueCount,yaxis:2,lineWidth:1},i.issueCount)),t.push(e.defaults({color:n.unestimated,yaxis:2,lineWidth:1},i.unestimatedIssueCount))),this.calculateSeriesFromIds(t)},h.prototype.calculateSeriesFromIds=function(t){var i=this.timelineData,s=i?i.timeline:void 0,a=this.series=[];if(!e.isEmpty(s)){var r={},u={};e.each(t,function(t){r[t.id]=[],u[t.id]=[]}),e.each(s,function(i){e.each(t,function(t){this.shouldAddToSeries(t,i.issues)&&(i.deltas&&e.isNumber(i.deltas[t.id])&&0!=i.deltas[t.id]&&(r[t.id].push([i.time,i.values[t.id]-i.deltas[t.id]]),u[t.id].push({})),r[t.id].push([i.time,i.values[t.id]]),u[t.id].push(i))},this)},this);var c=e.last(s);!i.completeTime||i.completeTime>i.now?e.each(t,function(t){r[t.id].push([Math.max(i.startTime,i.now),c.values[t.id]])}):e.each(t,function(t){r[t.id].push([i.completeTime,c.values[t.id]])}),this.isTimeTracking()&&a.push({id:"timeSpent",data:r.timeSpent,color:n.timeSpent,label:AJS.I18n.getText("gh.issue.time")}),e.each(t,function(t){a.push({id:t.id,data:r[t.id],color:t.color,label:t.label,yaxis:t.yaxis,lines:{fill:t.fill,lineWidth:t.lineWidth,show:!0}})}),a.push({id:"markings",color:n.nonWorkingDays,data:[],label:AJS.I18n.getText("gh.rapid.chart.burndown.nonworkingdays.label")});var d=i.maxValues.totalEstimate;this.yAxisData=o.calculateYAxis(d,this.statistic),this.yAxisData.min=0,this.yAxisData.max=d,this.series=a,this.seriesData=u}},h.prototype.getXAxisStart=function(){var t=.02;return this.chartData.startTime-(this.chartData.endTime-this.chartData.startTime)*t},h.prototype.getYAxes=function(){var t=[];if(t.push(this.yAxisData),!this.isIssueCountStatistic()){var e=this.timelineData.maxValues.issueCount,i=1;e>15&&(i=Math.ceil(e/8)),t.push({position:"right",min:0,tickFormatter:function(t,e){return t.toFixed(0)},tickSize:i})}return t},h.prototype.getDataBySeries=function(t){return this.seriesData&&this.seriesData[t]},h.prototype.getTooltipData=function(t,i){var s={};return i.initial?(i.initial&&(s.initial=!0,s.event=this.getEpicStartChangeEvent()),s.issueCount=e.size(i.issues),s.statisticName=this.getSeriesStatisticName(t),s.statisticValue=u.renderStatisticText(i.values[t],!1,this.getSeriesRenderer(t))):(s.changes=[],e.each(i.issues,function(e){var i={};i.key=e.key,i.statisticName=this.getSeriesStatisticName(t),i.statisticDelta=u.renderStatisticText(e.deltas[t],!1,this.getSeriesRenderer(t)),i.event=this.getChangeEvent(e),s.changes.push(i)},this)),s.dateText=u.renderUTCMillisAsDate(i.time),s},h.prototype.getSeriesRenderer=function(t){var e=this.getAllSeriesDefinitions();return e[t].renderer},h.prototype.getSeriesStatisticName=function(t){var e=this.getAllSeriesDefinitions();return e[t].statisticName},h.prototype.getDataBySeriesAtIndex=function(t,e){var i=this.getDataBySeries(t);if(i)return i[e]},h.prototype.getChangeEvent=function(t){var i=AJS.I18n.getText("gh.report.progress.event.burndown.type"),s=this.getScopeOrColumnChangeEvent(t,i);if(s)return s;if(t.estimateChange){var a=t.values.oldEstimateFieldValue,n=t.values.estimateFieldValue,r=!e.isUndefined(a),o=!e.isUndefined(n);return r&&o?{type:AJS.I18n.getText("gh.rapid.chart.burndown.event.scope.change.type"),detail:AJS.I18n.getText("gh.rapid.chart.burndown.event.scope.change.detail.statistic.value.changed",this.renderStatisticText(a),this.renderStatisticText(n))}:r?{type:AJS.I18n.getText("gh.rapid.chart.burndown.event.scope.change.type"),detail:AJS.I18n.getText("gh.rapid.chart.burndown.event.scope.change.detail.statistic.value.removed",this.renderStatisticText(a))}:{type:AJS.I18n.getText("gh.rapid.chart.burndown.event.scope.change.type"),detail:AJS.I18n.getText("gh.rapid.chart.burndown.event.scope.change.detail.statistic.value.added",this.renderStatisticText(n))}}return{type:"unknown",detail:"unknown change"}},h.prototype.getScopeOrColumnChangeEvent=function(t,e){return t.scopeChange?t.inScope?{type:AJS.I18n.getText("gh.rapid.chart.burndown.event.scope.change.type"),detail:this.issueAddedText}:{type:AJS.I18n.getText("gh.rapid.chart.burndown.event.scope.change.type"),detail:this.issueRemovedText}:s.getColumnChangeEvent(t,e)},h.prototype.getStartChangeEvent=function(){return{type:this.startText,detail:""}},h.prototype.getSeries=function(){return this.series},h.prototype.getXAxisEnd=function(){},h.prototype.resolveIssueEntities=function(){var t=this;[this.data.contents.completedIssues,this.data.contents.incompleteEstimatedIssues,this.data.contents.incompleteUnestimatedIssues].forEach(function(e){return r.resolveEntities(e,t.data.contents.entityData)})},h.prototype.ensureIssuesHaveEstimateText=function(){function t(t){return e.isUndefined(t.estimateStatistic)||e.isUndefined(t.estimateStatistic.statFieldValue.value)?t.estimateStatistic={statFieldValue:{text:"-"}}:t.estimateStatistic.statFieldValue.text=s(t.estimateStatistic.statFieldValue.value),t}var i=this.getReportContent(),s=this._getValueRenderer();i.completedIssues=e.map(this.data.contents.completedIssues,t),i.incompleteUnestimatedIssues=e.map(this.data.contents.incompleteUnestimatedIssues,t),i.incompleteEstimatedIssues=e.map(this.data.contents.incompleteEstimatedIssues,t)},h.prototype._getValueRenderer=function(){var t;return t="duration"===this.getStatistic().renderer?c.formatShortDurationForTimeTrackingConfiguration:d.format},h.prototype.makeStatisticsValuesRenderable=function(){var t=this.getReportContent(),e=this._getValueRenderer();t.completedIssuesEstimateSum.text=e(t.completedIssuesEstimateSum.value),t.incompletedIssuesEstimateSum.text=e(t.incompletedIssuesEstimateSum.value)},h.prototype.getJql=function(){return this.jql},h.prototype.getDoneStatuses=function(){return this.data.doneStatuses},h.prototype.getNotDoneStatuses=function(){return this.data.notDoneStatuses},h.prototype.renderStatisticText=function(t,e){return u.renderStatisticText(t,e,this.getStatistic().renderer)},h});