function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

AJS.test.require(['com.pyxis.greenhopper.jira:gh-test-common', 'com.pyxis.greenhopper.jira:gh-rapid'], function () {
    var BurndownTimelineProducer = require('jira-agile/rapid/ui/chart/burndown-timeline-producer');
    var sprintStartTime = 1521510082835;
    var statisticConsumer = {
        datafields: [],
        beforeSprintStart: function beforeSprintStart() {}
    };

    test('module "jira-agile/rapid/ui/chart/burndown-timeline-producer" exists', function () {
        ok(BurndownTimelineProducer);
        ok(GH.BurndownTimelineProducer);
    });

    test('BurndownTimelineProducer.calculateTimeline() returns proper data given minimal values', function () {
        var sprintCompleteTime = null;
        var changes = {};
        var openCloseChanges = {};

        var expectations = {
            issueState: {},
            timeline: [{
                time: sprintStartTime,
                issues: [],
                values: {},
                initial: true
            }],
            currentValues: {},
            maxValues: {},
            pastSprintStart: true,
            statisticConsumer: statisticConsumer,
            estimatableIssueKeys: null
        };

        var reality = BurndownTimelineProducer.calculateTimeline(sprintStartTime, sprintCompleteTime, changes, openCloseChanges, statisticConsumer, null);
        deepEqual(expectations, reality, "Data without startSprint event built as expected");
    });

    test('BurndownTimelineProducer.calculateTimeline() builds proper timeline for a sprint with start and end logged', function () {
        var _changes, _openCloseChanges;

        var sprintCompleteTime = 1521756211521;
        var changes = (_changes = {}, _defineProperty(_changes, sprintStartTime, {}), _defineProperty(_changes, sprintCompleteTime, {}), _changes);
        var openCloseChanges = (_openCloseChanges = {}, _defineProperty(_openCloseChanges, sprintStartTime, [{
            operation: "OPEN",
            userDisplayNameHtml: "testName"
        }]), _defineProperty(_openCloseChanges, sprintCompleteTime, [{
            operation: "CLOSED",
            userDisplayNameHtml: "testName2"
        }]), _openCloseChanges);

        var expectations = [{
            initial: true,
            time: sprintStartTime,
            issues: [],
            values: {},
            openCloseInstances: openCloseChanges[sprintStartTime]
        }, {
            complete: true,
            time: sprintCompleteTime,
            issues: [],
            values: {}
        }];

        var reality = BurndownTimelineProducer.calculateTimeline(sprintStartTime, sprintCompleteTime, changes, openCloseChanges, statisticConsumer, null).timeline;
        deepEqual(expectations, reality, "Data for sprint started and completed built as expected");
    });
});