AJS.test.require(['com.pyxis.greenhopper.jira:gh-test-common', 'com.pyxis.greenhopper.jira:gh-rapid'], function () {
    var BurndownTimelineProducer = require('jira-agile/rapid/ui/chart/burndown-timeline-producer');
    var sprintStartTime = 1521510082835;
    var statisticConsumer = {
        datafields: [],
        beforeSprintStart: function () {
        }
    };

    test('module "jira-agile/rapid/ui/chart/burndown-timeline-producer" exists', function () {
        ok(BurndownTimelineProducer);
        ok(GH.BurndownTimelineProducer);
    });

    test('BurndownTimelineProducer.calculateTimeline() returns proper data given minimal values', function () {
        var sprintCompleteTime = null;
        var changes = {};
        var openCloseChanges = {};

        var expectations = {
            issueState: {},
            timeline: [{
                time: sprintStartTime,
                issues: [],
                values: {},
                initial: true
            }],
            currentValues: {},
            maxValues: {},
            pastSprintStart: true,
            statisticConsumer: statisticConsumer,
            estimatableIssueKeys: null
        };

        var reality = BurndownTimelineProducer.calculateTimeline(sprintStartTime, sprintCompleteTime, changes, openCloseChanges, statisticConsumer, null);
        deepEqual(expectations, reality, "Data without startSprint event built as expected");
    });

    test('BurndownTimelineProducer.calculateTimeline() builds proper timeline for a sprint with start and end logged', function () {
        var sprintCompleteTime = 1521756211521;
        var changes = {
            [sprintStartTime] : {},
            [sprintCompleteTime] : {}
        };
        var openCloseChanges = {
            [sprintStartTime]: [
                {
                    operation: "OPEN",
                    userDisplayNameHtml: "testName"
                }
            ],
            [sprintCompleteTime]: [
                {
                    operation: "CLOSED",
                    userDisplayNameHtml: "testName2"
                }
            ]
        };

        var expectations = [
            {
                initial: true,
                time: sprintStartTime,
                issues: [],
                values: {},
                openCloseInstances: openCloseChanges[sprintStartTime]
            },
            {
                complete: true,
                time: sprintCompleteTime,
                issues: [],
                values: {}
            }
        ];

        var reality = BurndownTimelineProducer.calculateTimeline(sprintStartTime, sprintCompleteTime, changes, openCloseChanges, statisticConsumer, null).timeline;
        deepEqual(expectations, reality, "Data for sprint started and completed built as expected");
    });
});
