AJS.test.require(['com.pyxis.greenhopper.jira:gh-test-common', 'com.pyxis.greenhopper.jira:gh-rapid'], function () {
    var BurndownTableProducer = require('jira-agile/rapid/ui/chart/burndown-table-producer');
    var statisticConsumer = {
        datafields: [],
        beforeSprintStart: function () {
        }
    };
    var tableHandler = {
        getStatisticDefinitions: function () {

        }
    };
    var lastUserWhoClosedHtml = "test name";
    var sprintStartTime = 1521510082835;

    test('module "jira-agile/rapid/ui/chart/burndown-table-producer" exists', function () {
        ok(BurndownTableProducer);
        ok(GH.BurndownTableProducer);
    });

    test('BurndownTableProducer.getDataTable() builds proper table with minimal timeline', function () {
        var timelineData = {
            timeline: [{
                initial: true,
                time: sprintStartTime,
                issues: [],
                values: {}
            }]
        };

        var expectations = [
            {
                event: {
                    detail: "",
                    type: "gh.rapid.chart.burndown.event.sprint.start.type.anonymous",
                    typeAsHtml: true
                },
                initial: true,
                issues: [],
                time: sprintStartTime,
                values: {}
            }
        ];

        var reality = BurndownTableProducer.getDataTable(timelineData, tableHandler, statisticConsumer, lastUserWhoClosedHtml).rows;
        deepEqual(expectations, reality, "Table for minimal timeline built as expected");
    });

    test('BurndownTableProducer.getDataTable() builds proper table for a sprint with start and end logged', function () {
        var sprintCompleteTime = 1521756211521;

        var timelineData = {
            timeline: [
                {
                    initial: true,
                    time: sprintStartTime,
                    issues: [],
                    values: {},
                    openCloseInstances: [{
                        operation: "OPEN",
                        userDisplayNameHtml: "testName"
                    }]
                },
                {
                    complete: true,
                    time: sprintCompleteTime,
                    issues: [],
                    values: {}
                }
            ]
        };

        var expectations = [
            {
                event: {
                    detail: "",
                    type: "gh.rapid.chart.burndown.event.sprint.start.type",
                    typeAsHtml: true
                },
                initial: true,
                issues: [],
                openClose: true,
                time: sprintStartTime,
                values: {}
            },
            {
                event: {
                    detail: "",
                    type: "gh.rapid.chart.burndown.event.sprint.end.type",
                    typeAsHtml: true
                },
                complete: true,
                issues: [],
                time: sprintCompleteTime,
                values: {}
            }
        ];

        var reality = BurndownTableProducer.getDataTable(timelineData, tableHandler, statisticConsumer, lastUserWhoClosedHtml).rows;
        deepEqual(expectations, reality, "Table for sprint started and completed built as expected");
    });
});