GH.RapidBoard.QuickCreate = {};

(function() {
    var AnalyticsTracker = require('jira-agile/rapid/analytics-tracker');
    /**
     * @type module:jira-agile/rapid/analytics-tracker
     */
    GH.RapidBoard.QuickCreate.analytics = new AnalyticsTracker("gh.quickcreate");
})();

/**
 * Initializes QuickCreate
 */
GH.RapidBoard.QuickCreate.init = function () {
    // listen for issue creation events
    function fireEvent(subtask) {
        return function(e, issues) {
            AJS.$(GH).trigger('issueCreated', { issues: issues, isSubtask: subtask});

            var eventData = _.pluck(issues, "issueKey");
            GH.RapidBoard.QuickCreate.analytics.trigger("create", eventData);
        };
    }

    JIRA.unbind("QuickCreateIssue.sessionComplete");
    JIRA.bind("QuickCreateIssue.sessionComplete", fireEvent(false));

    // listen for subtask creation to publish success message. See jira-quick-edit plugin.
    JIRA.unbind("QuickCreateSubtask.sessionComplete");
    JIRA.bind("QuickCreateSubtask.sessionComplete", fireEvent(true));

    // same thing for epic creation
    JIRA.unbind("QuickCreateEpic.sessionComplete");
    JIRA.bind("QuickCreateEpic.sessionComplete", fireEvent(false));
};

/**
 * Shows a message at the bottom when the user has created issues but can not see them with current filter
 *
 * @param data object containing issues and isSubtask flag
 * @param workModeData (optional) only included in Scrum work mode, contains sprint data to show add to sprint link
 */
GH.RapidBoard.QuickCreate.showCreatedIssuesMessage = function (data, workModeData) {
    var epicTypeId = GH.EpicConfig.getEpicIssueTypeId();
    var sprintFieldId = GH.SprintConfig.getSprintFieldId();
    var params = {
        issues: data.issues,
        isSubtask: !!data.isSubtask,
        isRankable: GH.BacklogModel.isRankable() || GH.RankingModel.isRankable()
    };

    if (workModeData) {
        // Only needed for work mode - used for creating the link to add issue to sprint in work mode
        // the issue data is not present when this function is called from plan mode
        var issuesExcludingEpics = _.filter(data.issues, function(issue) {
            // created issue details is not present in JIRA 5.1 or 5.2, so we don't include these issues
            // this way the link is not displayed unless we know we can add those issues
            return issue.createdIssueDetails && issue.createdIssueDetails.fields.issuetype.id != epicTypeId;
        });
        var shouldShowAddToSprints = !(_.find(data.issues, function(issue) {
            if (issue.createdIssueDetails && issue.createdIssueDetails.fields[sprintFieldId]) {
                return issue.createdIssueDetails.fields[sprintFieldId].length > 0;
            } else {
                return false;
            }
        }));
        params = _.extend(params, { isWorkMode: true, issuesExcludingEpics: issuesExcludingEpics, shouldShowAddToSprints: shouldShowAddToSprints }, workModeData);
    }

    GH.Notification.showSuccess(GH.tpl.quickcreate.renderFilteredIssuesSuccess(params), {timeout: 10000});
};

/**
 * Shows a message at the bottom when the user has created subtasks that are visible.
 *s
 * @param object object containing issues and isSubtask flag
 */
GH.RapidBoard.QuickCreate.showSubtaskCreatedMessage = function (data) {
    GH.Notification.showSuccess(GH.tpl.quickcreate.renderSubtasksAddedMessage({issues: data.issues}), {timeout: 10000});
};

/**
 * Shows a message at the bottom when the user has created epics
 *s
 * @param object object containing epics
 */
GH.RapidBoard.QuickCreate.showCreatedEpicsMessage = function (data, isVisible) {
    GH.Notification.showSuccess(GH.tpl.quickcreate.renderEpicsAddedMessage({isVisible: isVisible, epics: data.issues}), {timeout: 10000});
};
