(function($, _, Events) {
    function PageableCollection(items, options) {
        options = options || {};
        this.collection = items;
        this.pageSize = options.pageSize || 25;
        this.state = {
            currentPage: 1,
            firstPage: 1,
            lastPage: 0
        };
    }

    PageableCollection.prototype = new Events();

    _.extend(PageableCollection.prototype, {
        setCollection: function setCollection(collection, start, total) {
            this.collection = collection;
            this.state.collectionLength = total;
            this.state.lastPage = Math.ceil(this.state.collectionLength / this.pageSize);
            this.state.currentPage = 1 + Math.ceil(start / this.pageSize);
        },
        getPaginated: function getPaginated() {
            return this.collection;
        },
        setPage: function setPage(page) {
            page = parseInt(page, 10);
            if (!isNaN(page)) {
                this.state.currentPage = Math.max(Math.min(page, this.state.lastPage), this.state.firstPage);
            }
        },
        previousPage: function previousPage() {
            if (this.currentPage > 1) {
                this.setPage(this.state.currentPage - 1);
            }
        },
        nextPage: function nextPage() {
            var maxPage = Math.floor(this.state.collectionLength / this.pageSize);
            if (this.currentPage < maxPage) {
                this.setPage(this.state.currentPage + 1);
            }
        },
        remove: function remove(elementId) {
            this.collection = this.collection.filter(element => element.id !== elementId);
        }
    });

    GH.Pagination = GH.Pagination || {};
    GH.Pagination.PageableCollection = PageableCollection;

}(AJS.$, _, GH.Events));