GH.RankController = {};

/**
 * Issue ranking.
 */
GH.RankController.rankIssues = function (customFieldId, issueKeys, nextIssueKey, prevIssueKey, settings) {
    settings = settings || {};
    var data = {
        issueKeys : issueKeys,
        customFieldId : customFieldId
    };
    var op;

    if (prevIssueKey) {
        op = 'after';
        if (_.isNumber(prevIssueKey)) {
            data['rankAfterRankable'] = {
                type: 'sprintmarker',
                id: prevIssueKey
            };
        } else {
            data['rankAfterKey'] = prevIssueKey;
        }
    } else if (nextIssueKey) {
        op = 'before';
        if (_.isNumber(nextIssueKey)) {
            data['rankBeforeRankable'] = {
                type: 'sprintmarker',
                id: nextIssueKey
            };
        } else {
            data['rankBeforeKey'] = nextIssueKey;
        }
    } else {
        // no operation
        return AJS.$.Deferred().resolve().promise();
    }

    var newSettings = _.extend(settings, {
        url: '/api/rank/' + op,
        data: data
    });

    return GH.Ajax.put(newSettings).promise();
};

GH.RankController.rankEpics = function (customFieldId, epicId, nextEpicId, prevEpicId, settings) {
    if (!prevEpicId && !nextEpicId) {
        return AJS.$.Deferred().resolve().promise();
    }

    var data = {
        rankCustomFieldId : customFieldId
    };

    if (prevEpicId) {
        data.rankAfterEpic = prevEpicId;
    } else {
        data.rankBeforeEpic = nextEpicId;
    }

    var newSettings = _.extend(settings || {}, {
        bareUrl: GH.Ajax.buildPublicRestUrl('epic/' + epicId + '/rank'),
        data: data
    });

    return GH.Ajax.put(newSettings).promise();
};

/**
 * Adds/removes issues from a future/active sprint and ranks issues at the same time
 *
 * @param sprintId the id of the sprint, null for ranking the issues to the backlog (thus removing the issues from any
 * future/active sprint)
 */
GH.RankController.sprintRankIssues = function (customFieldId, issueKeys, sprintId, nextIssueKey, prevIssueKey, settings, requireReorder) {
    settings = settings || {};
    var data = {
        idOrKeys : issueKeys,
        customFieldId : customFieldId,
        rapidViewId: GH.RapidBoard.State.getRapidViewId(),
        calculateNewIssuesOrder: requireReorder
    };
    if (sprintId) {
        data.sprintId = sprintId;
        data.addToBacklog = false;
    } else {
        data.sprintId = null;
        data.addToBacklog = true;
    }
    if (nextIssueKey) {
        data.idOrKeyBefore = nextIssueKey;
    }
    if (prevIssueKey) {
        data.idOrKeyAfter = prevIssueKey;
    }

    var newSettings = _.extend(settings, {
        url: '/sprint/rank',
        data: data
    });

    return GH.Ajax.put(newSettings).promise();
};

/**
 * @returns the first rankResult that contains an error
 */
GH.RankController.getErrorRankResultFromResponse = function(response) {
    // process a response
    return response.isSuccess() && _.find(response.success.rankableChanges, function(rankResult) {
        return rankResult.errors && rankResult.errors.length > 0;
    } );
};
