/**
 * Mouse utilities
 */
GH.MouseUtils = {};

GH.MouseUtils.openInSameTab = function(e) {
    // if it is a left click or simulated or IE misbehaving (http://bugs.jquery.com/ticket/11741)
    return (_.isUndefined(e.which) || e.which === null || e.which === 1 || (e.which === 0 && AJS.$.browser.msie)) &&
        // and has not modifiers which would indicate the user wants it opened in a separate tab
        !(e.metaKey || e.ctrlKey || e.shiftKey || (e.altKey && !AJS.$.browser.msie));
};

/**
 * Get the meta keys
 */
GH.MouseUtils.getMetaKeys = function(event) {
    if (event) {
        return {
            metaPressed: event.metaKey || event.ctrlKey,
            shiftPressed: event.shiftKey
        };
    } else {
        return {
            metaPressed: false,
            shiftPressed: false
        };
    }
};

GH.MouseUtils.hasMetaKeys = function(keys) {
    return keys.metaPressed || keys.shiftPressed;
};
GH.MouseUtils.isMetaPressed = function(keys) {
    return keys.metaPressed;
};
GH.MouseUtils.isShiftPressed = function(keys) {
    return keys.shiftPressed;
};
