AJS.test.require(["com.pyxis.greenhopper.jira:gh-rapid", "com.pyxis.greenhopper.jira:gh-test-common"], function () {
    var planModeEnabled = false;
    var updatePlanMode = function (state) {
        planModeEnabled = state;
    };

    module("Keyboard shortcuts", {
        setup: function () {
            this.sandbox = sinon.sandbox.create();

            this.sandbox.stub(GH.RapidBoard.State, 'isPlanModeAvailable', function () {
                return planModeEnabled;
            });
            this.sandbox.stub(GH.RapidBoard.ViewController, 'setMode');
            this.sandbox.stub(GH.Shortcut, 'workMode');
        },
        teardown: function () {
            this.sandbox.restore();
        }
    });

    test("backlog shortcut displays backlog when kanplan backlog is enabled", function () {
        updatePlanMode(true);
        GH.Shortcut.planMode();
        sinon.assert.calledWith(GH.RapidBoard.ViewController.setMode, 'plan');
        sinon.assert.notCalled(GH.Shortcut.workMode);
    });

    test("backlog shortcut displays kanban board instead when kanplan backlog is disabled", function () {
        updatePlanMode(false);
        GH.Shortcut.planMode();
        sinon.assert.called(GH.Shortcut.workMode);
        sinon.assert.neverCalledWith(GH.RapidBoard.ViewController.setMode, 'plan');
    });
});