/* global submitOnEnter */
/**
 * Instantiates jql autocomplete functionality on request instead of on page load.
 *
 * Required data is not stored in the dom, but provided as a resource included in the page.
 */

GH.JQLAutoComplete.setModel = function (model) {
    GH.JQLAutoComplete.jqlFields = JSON.parse(model.JQLAutoComplete.jqlFields);
    GH.JQLAutoComplete.jqlFunctionNames = JSON.parse(model.JQLAutoComplete.jqlFunctionNames);
    GH.JQLAutoComplete.jqlReservedWords = JSON.parse(model.JQLAutoComplete.jqlReservedWords);
};

/**
 * Initializes an auto complete field
 */
GH.JQLAutoComplete.initialize = function (fieldID, errorID) {

    /*jQuery.expr[':'].focus = function( elem ) {
      return elem === document.activeElement && ( elem.type || elem.href );
    };*/

    var field = AJS.$('#' + fieldID);
    var hasFocus = field.length > 0 && field[0] === document.activeElement;

    //restore('jqlHistory');

    // unlike JIRA, we should already have the values in javascript variables

    var jqlAutoComplete = JIRA.JQLAutoComplete({
        fieldID: fieldID, //'jqltext',
        parser: JIRA.JQLAutoComplete.MyParser(GH.JQLAutoComplete.jqlReservedWords),
        queryDelay: 0.65,
        jqlFieldNames: GH.JQLAutoComplete.jqlFields,
        jqlFunctionNames: GH.JQLAutoComplete.jqlFunctionNames,
        minQueryLength: 0,
        allowArrowCarousel: true,
        autoSelectFirst: false,
        errorID: errorID //'jqlerrormsg'
    });

    var jQueryRef = jQuery('#' + fieldID); //'#jqltext');

    // ensure we don't submit anything
    jQueryRef.unbind("keypress", submitOnEnter) /*.keypress(
                                                function (e) {
                                                if (jqlAutoComplete.dropdownController === null || !jqlAutoComplete.dropdownController.displayed || jqlAutoComplete.selectedIndex < 0) {
                                                if (e.keyCode == 13 && !e.ctrlKey && ! e.shiftKey)
                                                {
                                                jQuery('#jqlform').submit();
                                                return false;
                                                }
                                                else
                                                {
                                                return true;
                                                }
                                                }
                                                })*/;
    jqlAutoComplete.buildResponseContainer();
    jqlAutoComplete.parse(jQueryRef.text());
    jqlAutoComplete.updateColumnLineCount();

    jQueryRef.click(function () {
        jqlAutoComplete.dropdownController.hideDropdown();
    });

    //unfortunately normal resize event doesn't work... Need to use mouse magic
    jQueryRef.mousedown(function () {
        jQueryRef.mousemove(function () {
            if (this.style.height !== this.oldheight) {
                jqlAutoComplete.positionResponseContainer();
            }
            this.oldheight = this.style.height;
        });
    });

    // dropdown is located at some strange place during page rendering, so we fix location when gaining focus for the first time
    jQueryRef.focus(function (event) {
        jqlAutoComplete.positionResponseContainer();
        jQueryRef.unbind(event);
    });

    jQueryRef.mouseup(function () {
        jQueryRef.off('mousemove');
    });

    if (hasFocus) {
        field.select();
    }

    // keep reference around
    field.data('ghJqlAutoComplete', jqlAutoComplete);
};

GH.JQLAutoComplete.fixSuggestionPositioning = function (fieldId) {
    var autoComplete = AJS.$('#' + fieldId).data('ghJqlAutoComplete');
    if (autoComplete) {
        // before JIRA 5.2 there's not such function, so lets define it here
        // Code copied from JIRA 5.2, added sanity checks
        if (!autoComplete.positionResponseContainer) {
            autoComplete.positionResponseContainer = function () {
                if (!this.responseContainer || !this.field) {
                    return;
                }
                this.responseContainer.css({ top: this.field.outerHeight() });
            };
        }
        autoComplete.positionResponseContainer();
    }
};