define('jira-agile/rapid/configuration/timed-flag', [
    'jira/flag',
    'jquery'
], function (
    jiraFlag,
    $
) {
    return {
        successMsgTimed: function (title, content, options, timeout) {
            options = options || {};

            if (timeout) {
                options.close = 'manual';
            }

            var $flag = $(jiraFlag.showSuccessMsg(
                title,
                content,
                options
            ));

            if (timeout) {
                setTimeout(function () {
                    $flag[0].close();
                }, timeout);
            }

            return $flag;
        }
    };
});