AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common-base", "com.pyxis.greenhopper.jira:gh-rapid-config"], function() {

    const ManageViews = require('jira-agile/rapid/configuration/manage-views');

    module("fetchConfiguration", {
        setup: function() {
            GH.Test.setUpFakeServer(this);
        },
        teardown: function() {
            GH.Test.restoreServer(this);
        }
    });

    /* The purpose of these tests is to ensure the ajax calls are not broken while making a significant refactoring to how GH.Ajax works */
    test("Successful AJAX call renders the view list", sinon.test(function() {

        this.stub(ManageViews, "render");

        GH.Test.respondToGetWith200(this, "/rapidviews/viewsData.json", {});

        ManageViews.loadModel();

        this.server.respond();

        ok(ManageViews.render.called, "Called success method");

    }));

    test("Failed AJAX call does not render (no error handling)", sinon.test(function() {
        this.stub(ManageViews, "render");

        GH.Test.respondToGetWith500(this, "/rapidviews/list.json", {});

        ManageViews.loadModel();

        this.server.respond();

        ok(!ManageViews.render.called, "Does not render on failure");
    }));
});