define('jira-agile/rapid/configuration/kanban-backlog-feedback-collector', [
    'jira-agile/rapid/configuration/column-config-analytics',
    'jquery'
], function (
    ColumnConfigAnalytics,
    $
) {
    return {
        configureFeedbackCollector: function ($link, model, $sourceColumn, $destinationColumn) {
            $.ajax({
                url: "https://jira.atlassian.com/s/c0ee7481af1f09efe3d85af9bf8b8d01-T/7fmdi8/73011/b6b48b2829824b869586ac216d119363/2.0.23/_/download/batch/com.atlassian.jira.collector.plugin.jira-issue-collector-plugin:issuecollector-embededjs/com.atlassian.jira.collector.plugin.jira-issue-collector-plugin:issuecollector-embededjs.js?locale=en-UK&collectorId=8fc8b2bf",
                type: "get",
                cache: true,
                dataType: "script"
            });
            window.ATL_JQ_PAGE_PROPS = {
                "triggerFunction": function (showCollectorDialog) {
                    $link.click(function (e) {
                        e.preventDefault();
                        ColumnConfigAnalytics.triggerKanbanDisabledFeedbackCollectorLink(model, $sourceColumn, $destinationColumn);
                        showCollectorDialog();
                    });
                }
            };
        }
    };
});