AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-config-restful-delete-dialog"], function () {
    const $ = require('jquery');

    var dialogHtml = '<div class="aui-dialog2 gh-confirm-delete-dialog">' +
        '<button type="submit"></button>' +
        '<div class="aui-dialog2-header-close"></div>' +
        '<div class="cancel"></div>' +
        '</div>';

    module("loadContent", {
        setup: function () {
            this.context = AJS.test.mockableModuleContext();
            const dialog = {
                hide: sinon.spy(),
                remove: sinon.spy()
            };

            this.dialog = dialog;
            this.dialog2 = sinon.stub().returns({
                show: sinon.stub().returns(dialog)
            });

            this.context.mock('aui/dialog2', this.dialog2);
            this.DeleteConfirmation = this.context.require('jira-agile/rapid/configuration/delete-confirmation');

            this.btnSubmit = function () {
                return $('.gh-confirm-delete-dialog button');
            };
            this.btnClose = function () {
                return $('.gh-confirm-delete-dialog .aui-dialog2-header-close');
            };
            this.btnCancel = function () {
                return $('.gh-confirm-delete-dialog .cancel');
            };

            $('#qunit-fixture').append(dialogHtml);
        }
    });

    test("Submit should resolve promise", sinon.test(function (assert) {
        assert.expect(3);
        const done = assert.async();
        const promise = this.DeleteConfirmation.show(dialogHtml);
        promise.then(
            function () {
                sinon.assert.calledOnce(this.dialog.hide);
                sinon.assert.calledOnce(this.dialog.remove);
                ok(true);
                done();
            }.bind(this),
            function () {
                sinon.assert.calledOnce(this.dialog.hide);
                sinon.assert.calledOnce(this.dialog.remove);
                ok(false, 'should resolve promise');
                done();
            }.bind(this)
        );

        this.btnSubmit().click();
    }));

    test("Close should reject promise", sinon.test(function (assert) {
        assert.expect(3);
        const done = assert.async();
        const promise = this.DeleteConfirmation.show(dialogHtml);
        promise.then(
            function () {
                sinon.assert.calledOnce(this.dialog.hide);
                sinon.assert.calledOnce(this.dialog.remove);
                ok(false, 'should reject promise');
                done();
            }.bind(this),
            function () {
                sinon.assert.calledOnce(this.dialog.hide);
                sinon.assert.calledOnce(this.dialog.remove);
                ok(true);
                done();
            }.bind(this)
        );

        this.btnClose().click();
    }));

    test("Cancel should reject promise", sinon.test(function (assert) {
        assert.expect(3);
        const done = assert.async();
        const promise = this.DeleteConfirmation.show(dialogHtml);
        promise.then(
            function () {
                sinon.assert.calledOnce(this.dialog.hide);
                sinon.assert.calledOnce(this.dialog.remove);
                ok(false, 'should reject promise');
                done();
            }.bind(this),
            function () {
                sinon.assert.calledOnce(this.dialog.hide);
                sinon.assert.calledOnce(this.dialog.remove);
                ok(true);
                done();
            }.bind(this)
        );

        this.btnCancel().click();
    }));
});