define('jira-agile/rapid/configuration/delete-confirmation', [
    'aui/dialog2', 'jquery'
], function (dialog2, $) {
    return {
        /**
         * Shows delete confirmation and returns promise.
         * @param html
         * @returns {Promise<any>}
         */
        show: function (html) {
            const dialog = dialog2(html).show();
            return new Promise(function (resolve, reject) {
                $(".gh-confirm-delete-dialog button[type='submit']").click(function (e) {
                    resolve();
                    e.preventDefault();
                    dialog.hide();
                    dialog.remove();
                });
                $(".gh-confirm-delete-dialog .aui-dialog2-header-close, .gh-confirm-delete-dialog .cancel").click(function (e) {
                    reject();
                    e.preventDefault();
                    dialog.hide();
                    dialog.remove();
                });
            });
        }
    };
});