AJS.test.require("com.pyxis.greenhopper.jira:gh-rapid-common", function() {
    const UrlFormat = require('jira-agile/rapid/url-format');

    module("URL Format tests");

    test("UrlFormat#appendBaseUrl", function(){
        UrlFormat.defaultContextPath = "/jira";

        var testFormat = UrlFormat.prependBaseUrl("");
        equal(testFormat, "");

        testFormat = UrlFormat.prependBaseUrl("http://www.google.com");
        equal(testFormat, "http://www.google.com");

        testFormat = UrlFormat.prependBaseUrl("/images/icons/blah.gif");
        equal(testFormat, "/jira/images/icons/blah.gif");
    });

    test("UrlFormat.getUrlForIssues with no arguments", function () {
        UrlFormat.defaultContextPath = "/jira";

        var testUrl = UrlFormat.getUrlForIssues();
        equal(testUrl, "/jira/issues/?jql=");
    });

    test("UrlFormat.getUrlForIssues with an empty array", function () {
        UrlFormat.defaultContextPath = "/jira";

        var testUrl = UrlFormat.getUrlForIssues([]);
        equal(testUrl, "/jira/issues/?jql=");
    });

    test("UrlFormat.getUrlForIssues with an array containing malformed issues (no id)", function () {
        UrlFormat.defaultContextPath = "/jira";

        var testUrl = UrlFormat.getUrlForIssues([{},{}]);
        equal(testUrl, "/jira/issues/?jql=");
    });

    test("UrlFormat.getUrlForIssues with an array containing a single issue", function () {
        UrlFormat.defaultContextPath = "/jira";

        var testUrl = UrlFormat.getUrlForIssues([{id:1}]);
        equal(testUrl, "/jira/issues/?jql=id%20in%20(1)");
    });

    test("UrlFormat.getUrlForIssues with an array containing multiple issues", function () {
        UrlFormat.defaultContextPath = "/jira";

        var testUrl = UrlFormat.getUrlForIssues([{id:1},{id:2}]);
        equal(testUrl, "/jira/issues/?jql=id%20in%20(1%2C2)");
    });
});