define("jira-agile/rapid/time-format-displays", [], function () {
  /**
   * Represents the different configurations in JIRA's Time Tracking Administration for displaying duration values:
   *  'pretty' - e.g. 2w 4d 5h 30m
   *  'days'   - e.g. 14d 5.5h (where there are 5 days per week)
   *  'hours'  - e.g. 145.5h (where there are 10 hours in a day, 5 days in a week)
   */
  var TimeFormatDisplays = {};
  TimeFormatDisplays.PRETTY = 'pretty';
  TimeFormatDisplays.DAYS = 'days';
  TimeFormatDisplays.HOURS = 'hours';
  /**
   * Plus an additional display for limited space:
   *  'most-significant' - displays only the most significant unit rounded to 1 decimal place
   */
  TimeFormatDisplays.MOST_SIGNIFICANT = 'most-significant';

  return TimeFormatDisplays;
});

AJS.namespace("GH.TimeFormatDisplays", null, require("jira-agile/rapid/time-format-displays"));