define('jira-agile/rapid/sprints-data-service',
    ['jira-agile/rapid/ajax', 'underscore'], function (Ajax, _) {
        function SprintsDataService() {
        }


        /**
         * Get the active and historic sprints for the rapidViewId.
         * The returned sprints are in the form:
         *  [{"id":1,"sequence":1,"name":"Sprint 1","state":"CLOSED"},...]
         *
         * @param {number} rapidViewId
         * @returns {Promise}
         */
        SprintsDataService.prototype.getSimpleSprints = function (rapidViewId) {
            // then issue the request
            return Ajax.get({
                url: '/sprintquery/' + rapidViewId,
                data: {
                    includeHistoricSprints: true,
                    includeFutureSprints: false
                }
            }, 'getSimpleSprints').andThen(function (data) {
                return data.sprints;
            });
        };

        return SprintsDataService;
    });

AJS.namespace('GH.SprintsDataService', null, require('jira-agile/rapid/sprints-data-service'));
AJS.namespace('GH.sprintsDataService', null, new (require('jira-agile/rapid/sprints-data-service'))());
