require(['jira-agile/rapid/global-events', 'underscore', 'jira-agile/rapid/rapid-board'], function (GlobalEvents, _, RapidBoard) {
    var triggerGlobalBoardAnalyticEvent = function triggerGlobalBoardAnalyticEvent() {
        if (!_.isEmpty(RapidBoard.projectKey)) {
            JIRA.SmartAjax.makeRequest({
                type: "GET",
                contentType: "application/json",
                url: GH.Ajax.CONTEXT_PATH + '/rest/api/2/project/' + RapidBoard.projectKey,
                success: function success(result) {
                    if ('projectTypeKey' in result && result.projectTypeKey !== 'software') {
                        AJS.trigger('analytics', { name: 'RapidBoard.show.global', data: { projectType: result.projectTypeKey } });
                    }
                }
            });
        }
    };

    var setNewViewData = function setNewViewData(rapidViewData) {
        // update board header
        RapidBoard.BoardHeader.update(rapidViewData);

        GH.ViewActions.initViewActions(rapidViewData);
        GH.ViewActions.on('boardToolsRendered', function () {
            var mode = RapidBoard.State.getMode();
            var eventMode = !mode ? "board" : mode;

            AJS.$('#board-tools-section-content .js-view-action-copy').bind('click', function () {
                AJS.trigger('analyticsEvent', {
                    name: 'jira-software.' + eventMode + '.boardmenu.click.copy-board'
                });
            });

            AJS.$('#board-tools-section-content .js-view-action-create').bind('click', function () {
                AJS.trigger('analyticsEvent', {
                    name: 'jira-software.' + eventMode + '.boardmenu.click.create-board'
                });
            });

            AJS.$('#board-tools-section-content .js-view-action-configure').bind('click', function () {
                AJS.trigger('analyticsEvent', {
                    name: 'jira-software.' + eventMode + '.boardmenu.click.configure-board'
                });
            });
        });

        // tell the view controller about the new view
        RapidBoard.ViewController.update(rapidViewData);
    };

    var handleBoardData = function handleBoardData(selectedView) {
        RapidBoard.State.setRapidViewId(selectedView.id);

        // Welcome message case:
        // render the welcome and exit if we haven't got any views (if we have a view specified we don't want to do this
        // -- we want an error later on).
        var hasSelectedView = !_.isUndefined(selectedView);

        if (selectedView.noRapidViews) {
            // show welcome message
            var emptyViewData = {
                id: undefined,
                name: undefined,
                canEdit: false,
                invalidView: false
            };
            setNewViewData(emptyViewData);
            return;
        }

        if (hasSelectedView) {
            // Valid rapid view case
            setNewViewData(selectedView);
            // Send board-type analytics
            triggerGlobalBoardAnalyticEvent();
            AJS.trigger('analytics', { name: 'RapidBoard.show.' + (selectedView.sprintSupportEnabled ? 'scrum' : 'kanban'), data: { boardId: selectedView.id } });
        } else {
            // Invalid rapid view case
            setNewViewData({ invalidView: true });
        }
    };

    GlobalEvents.on('RapidBoard.reload', function () {
        var viewIdInfo = RapidBoard.State.getRapidViewIdWithInfo();
        GH.RapidViewConfig.fetchConfiguration(viewIdInfo).done(handleBoardData);
        if (viewIdInfo.viewId) {
            // Prefetch data for parallel REST request (performance)
            // This is thrown away if the view id turns out to be bad
            RapidBoard.ViewController.preload(viewIdInfo.viewId);
        }
    });

    RapidBoard.initialiseListeners.done(function (rapidBoardConfig) {
        // board header
        RapidBoard.BoardHeader.init();

        // main view controller
        RapidBoard.ViewController.init(rapidBoardConfig);

        // quick create
        RapidBoard.QuickCreate.init();

        // quick edit
        RapidBoard.QuickEdit.init();
    });

    RapidBoard.initialiseListenersDone.done(function () {
        // initialize the state
        RapidBoard.State.initializeState();

        // Call reload. The rest of that needs to be done is defined there
        RapidBoard.reload();

        // initialize the poller
        GH.Poller.init();
    });
});