AJS.test.require("com.pyxis.greenhopper.jira:gh-rapid-common", function() {
    var NumberFormat = require('jira-agile/rapid/number-format');

    module("Number Format tests");

    test("NumberFormat with String", function(){
        var testFormat = NumberFormat.format("asd");
        ok(_.isUndefined(testFormat), "expected NumberFormat.format to return undefined");

        testFormat = NumberFormat.format("0");
        ok(_.isUndefined(testFormat), "expected NumberFormat.format to return undefined");
    });

    test("NumberFormat with Integers", function(){
        var testFormat = NumberFormat.format(0);
        equal(testFormat, "0");
        testFormat = NumberFormat.format(1);
        equal(testFormat, "1");
        testFormat = NumberFormat.format(10);
        equal(testFormat, "10");
        testFormat = NumberFormat.format(111);
        equal(testFormat, "111");
        testFormat = NumberFormat.format(1234);
        equal(testFormat, "1,234");
        testFormat = NumberFormat.format(12345);
        equal(testFormat, "12,345");
        testFormat = NumberFormat.format(123456);
        equal(testFormat, "123,456");
        testFormat = NumberFormat.format(1234567);
        equal(testFormat, "1,234,567");
    });

    test("NumberFormat with Floats", function(){
        var testFormat = NumberFormat.format(0.0);
        equal(testFormat, "0");
        testFormat = NumberFormat.format(0.01);
        equal(testFormat, "0.01");
        testFormat = NumberFormat.format(0.1);
        equal(testFormat, "0.1");
        testFormat = NumberFormat.format(0.10);
        equal(testFormat, "0.1");
        testFormat = NumberFormat.format(0.11);
        equal(testFormat, "0.11");
        testFormat = NumberFormat.format(0.111);
        equal(testFormat, "0.11");
        testFormat = NumberFormat.format(0.115);
        equal(testFormat, "0.12");
        testFormat = NumberFormat.format(35.855);
        equal(testFormat, "35.86");
        testFormat = NumberFormat.format(1234.115);
        equal(testFormat, "1,234.12");
    });

    test("NumberFormat with Negative Numbers", function(){
        var testFormat = NumberFormat.format(-0.0);
        equal(testFormat, "0");
        testFormat = NumberFormat.format(-1.5);
        equal(testFormat, "-1.5");
        testFormat = NumberFormat.format(-1234.567);
        equal(testFormat, "-1,234.57");
        testFormat = NumberFormat.format(-1234567.89);
        equal(testFormat, "-1,234,567.89");
    });

    test("NumberFormat exponential", function(){
        var testFormat = NumberFormat.formatExponential(0);
        equal(testFormat, "0e0");
        testFormat = NumberFormat.formatExponential(1);
        equal(testFormat, "1e0");
        testFormat = NumberFormat.formatExponential(1.1);
        equal(testFormat, "1.1e0");
        testFormat = NumberFormat.formatExponential(1.1111);
        equal(testFormat, "1.11e0");
        testFormat = NumberFormat.formatExponential(-1);
        equal(testFormat, "-1e0");
        testFormat = NumberFormat.formatExponential(1000);
        equal(testFormat, "1e3");
        testFormat = NumberFormat.formatExponential(2994);
        equal(testFormat, "2.99e3");
        testFormat = NumberFormat.formatExponential(2995);
        equal(testFormat, "3e3");
    });
});
